#ifndef WAVE_BUFFER_H_
#define WAVE_BUFFER_H_

#include <cstddef>

namespace snd_wave_generator {

/**
 * @brief A class used to hold buffered sound wave data.
 * It's basically a vector of floats which can be read in a cyclic way.
 */
class WaveBuffer {
public:
    WaveBuffer() : size_(0), capacity_(0), data_(NULL) { }
    ~WaveBuffer() { delete[] this->data_; }
    
    void resize(std::size_t size);
    
    void write(std::size_t pos, float v) { 
        if (pos < this->size_) {
            this->data_[pos] = v; 
        }
    }
    
    float read(std::size_t pos) const { 
        return this->data_[pos % this->size_]; 
    }

private:
    std::size_t size_;
    std::size_t capacity_;
    float *data_;
};

} // snd_wave_generator

#endif // WAVE_BUFFER_H_