#include "snd_wave_generator/SineWave.h"
#include <cmath>

namespace snd_wave_generator {

void SineWave::prepare(std::size_t sampleRate)
{
    std::size_t cycleLength = sampleRate / this->frequency;
    this->buffer.resize(cycleLength);

    std::size_t middle = cycleLength / 2;
    std::size_t quarter = middle / 2;
    
    float delta = 6.28 / (float(sampleRate) / float(this->frequency));
    for(std::size_t i = 0; i < quarter; ++i) {
        float dt = delta * i;
        float dv = std::sin(dt) / 2.0;
        float posValue = 0.5 + dv;
        float negValue = 0.5 - dv;
        this->buffer.write(i, posValue);
        this->buffer.write(middle - i, posValue);
        this->buffer.write(middle + i, negValue);
        this->buffer.write(cycleLength - i, negValue);
    }
    
    this->buffer.write(quarter, 1.0);
    if (middle - quarter != quarter) {
        this->buffer.write(middle - quarter, 1.0);
    }
    this->buffer.write(cycleLength - quarter, 0.0);
    if (middle + quarter != cycleLength - quarter) {
        this->buffer.write(middle + quarter, 0.0);
    }
}

} // snd_wave_generator
