#ifndef WAVE_COMBO_H_
#define WAVE_COMBO_H_

#include "snd_wave_generator/Wave.h"
#include <vector>

namespace snd_wave_generator {

/**
 * @brief A class that produces a wave that results of the combination of multiple waves.
 * The combined wave does not buffer itself (as it does not know the length of the combined cycle.
 * During preparation phase, it invokes the prepare() method of its contained waves.
 */
class WaveCombo : public Wave {
public:
    WaveCombo(Wave *wave = NULL) : waves(), numWaves(0)
    {
        add(wave); 
    }
    
    WaveCombo & add(Wave *wave);
    
    virtual void prepare(std::size_t sampleRate);
    virtual float read(std::size_t pos) const;
    
private:
    std::vector<Wave*> waves;
    float numWaves;
};

} // snd_wave_generator

#endif // WAVE_COMBO_H_