#include "snd_wave_generator/WaveCombo.h"

#include <algorithm>
#include <functional>
#include <numeric>

namespace snd_wave_generator {

WaveCombo & WaveCombo::add(Wave *wave) { 
    if (wave) { 
        this->waves.push_back(wave);
        this->numWaves = this->waves.size(); 
    }
    
    return *this;
}

void WaveCombo::prepare(std::size_t sampleRate)
{
    std::for_each(this->waves.begin(), this->waves.end(),
        std::bind2nd(std::mem_fun(&Wave::prepare), sampleRate));
}

struct AccumulateWaveValueAt {
    AccumulateWaveValueAt(std::size_t pos) : pos(pos) { }
    float operator()(float acc, const Wave *wave) const {
        return acc + wave->read(this->pos);
    }
    
    std::size_t pos;
};

float WaveCombo::read(std::size_t pos) const {
    float v = std::accumulate(this->waves.begin(), this->waves.end(), 0.0f,
        AccumulateWaveValueAt(pos));
                
    return v / this->numWaves;
}

} // snd_wave_generator