#ifndef BUFFERED_WAVE_H_
#define BUFFERED_WAVE_H_

#include "snd_wave_generator/Wave.h"
#include "snd_wave_generator/WaveBuffer.h"

namespace snd_wave_generator {

/**
 * @brief A base class for Waves which pre-computes their values in a buffer during preparation and play from that buffer.
 */
class BufferedWave : public Wave {
public:
    BufferedWave() : buffer() { }
    virtual float read(std::size_t pos) const { return this->buffer.read(pos); }
    
protected:
    WaveBuffer buffer;
};

} // snd_wave_generator

#endif // BUFFERED_WAVE_H_
