#ifndef TRIANGLE_WAVE_H_
#define TRIANGLE_WAVE_H_

#include "snd_wave_generator/BufferedWave.h"

namespace snd_wave_generator {

/**
 * @brief A class producing a triangle wave of a given frequency.
 */
class TriangleWave : public BufferedWave {
public:
    TriangleWave(unsigned freq) : BufferedWave(), frequency(freq) { }

    virtual void prepare(std::size_t sampleRate);
    
private:
    unsigned frequency;
};

} // snd_wave_generator

#endif // TRIANGLE_WAVE_H_
