#ifndef SINE_WAVE_H_
#define SINE_WAVE_H_

#include "snd_wave_generator/BufferedWave.h"

namespace snd_wave_generator {

/**
 * @brief A class producing a sine wave of a given frequency.
 */
class SineWave : public BufferedWave {
public:
    SineWave(unsigned freq) : BufferedWave(), frequency(freq) { }

    virtual void prepare(std::size_t sampleRate);
    
private:
    unsigned frequency;
};

} // snd_wave_generator

#endif // SINE_WAVE_H_
