#include "snd_wave_generator/TriangleWave.h"

namespace snd_wave_generator {

void TriangleWave::prepare(std::size_t sampleRate)
{
    std::size_t cycleLength = sampleRate / this->frequency;
    this->buffer.resize(cycleLength);

    std::size_t middle = cycleLength / 2;
    std::size_t quarter = middle / 2;
    
    float delta = 2.0 / (float(sampleRate) / float(this->frequency));
    for(std::size_t i = 0; i < quarter; ++i) {
        float dt = delta * i;
        float posValue = 0.5 + dt;
        float negValue = 0.5 - dt;
        this->buffer.write(i, posValue);
        this->buffer.write(middle - i, posValue);
        this->buffer.write(middle + i, negValue);
        this->buffer.write(cycleLength - i, negValue);
    }
    
    this->buffer.write(quarter, 1.0);
    if (middle - quarter != quarter) {
        this->buffer.write(middle - quarter, 1.0);
    }
    this->buffer.write(cycleLength - quarter, 0.0);
    if (middle + quarter != cycleLength - quarter) {
        this->buffer.write(middle + quarter, 0.0);
    }
}

} // snd_wave_generator