#include "snd_wave_generator/SoundWaveGenerator.h"

namespace snd_wave_generator {

void SoundWaveGenerator::play(Wave *wave)
{
    wave->prepare(this->sampleRate);

    this->wave = wave;
    
    this->pos = 0;
    this->ticker.attach(this, &SoundWaveGenerator::tickerHandler, 1.0 / this->sampleRate);
}

void SoundWaveGenerator::stop()
{
    this->ticker.detach();
    this->output.write(0.0);
    this->wave = NULL;
}
    
void SoundWaveGenerator::tickerHandler()
{
    float v = this->wave ? this->wave->read(this->pos++) : 0.0;
    this->output.write(v);
}

} // snd_wave_generator
