#include "kbd_mgr/KeyboardManager.h"

#include <iostream>

using namespace std;
using namespace kbd_mgr;

void handleKeyPress(const KeyEvent &keypress) {
    char ch = (keypress.keyChar >= 32 && keypress.keyChar < 127 ? keypress.keyChar : '?');

    std::string eventName;
    switch (keypress.event) {
        case KeyEvent::KeyDown:
            eventName = "Down";
            break;
        case KeyEvent::KeyUp:
            eventName = "Up";
            break;
        case KeyEvent::KeyPress:
            eventName = "Press";
            break;
        case KeyEvent::RepeatedKeyPress:
            eventName = "RepeatedPress";
            break;
        case KeyEvent::LongKeyPress:
            eventName = "LongPress";
            break;
        default:
            eventName = "???";
            break;
    }

    cout << "Key state change: " << keypress.keyCode << " '" << ch << "' " << eventName << "\r" << endl;
}

int main() {
    cout << "\n\r\nKeyboardTest " __DATE__ "-" __TIME__ "\r" << endl;

    PinName outPinsArray[] = { p8, p7, p6, p5 };
    KeyboardMonitor::OutPinsSet outPins(&outPinsArray[0], &outPinsArray[4]);

    KeyMap keyMap("123A456B789C*0#D");
    keyMap(KeyEvent::LongKeyPress, 12, '@')(KeyEvent::LongKeyPress, 14, '$');
    
    KeyboardMonitor kbdMonitor(Port0, 4, 15, outPins);
    KeyboardStateChangeMonitor changeMonitor;
    SingleKeyPressMonitor keyPressMonitor;
    LongKeyPressMonitor longKeyPressMonitor;
    KeyMapper keyMapper(keyMap);

    longKeyPressMonitor.autoRepeat(0.500,0.250)(0,15);
    longKeyPressMonitor.longKeyPress(0.500)(12)(14);
    
    keyMapper.attach(handleKeyPress);
    longKeyPressMonitor.attach(keyMapper);
    keyPressMonitor.attach(longKeyPressMonitor);
    changeMonitor.attach(keyPressMonitor);
    kbdMonitor.attach(changeMonitor);

    kbdMonitor.start();

    while (1) {
        wait(10);
    }
}
