#ifndef KEYPRESS_EVENT_SERVER_H_
#define KEYPRESS_EVENT_SERVER_H_

#include "kbd_mgr/KeyboardEventServer.h"
#include "kbd_mgr/KeyPressEventHandler.h"

namespace kbd_mgr {

/**
 * @brief A base class for monitors that report keypresses.
 */ 
class KeyPressEventServer : public KeyboardEventServer<KeyPressEventHandler> {
public:
    /**
     * @brief Attaches the monitor to a function.
     * @param fn       Event handler called to report keyboard state change.
     */
    void attach(FunctionKeyPressEventHandler::HandlerFunction fn) {
        setHandler(new FunctionKeyPressEventHandler(fn));
    }
    
    /**
     * @brief Attaches the monitor to a method of an object.
     * @param obj      Event handler object
     * @param fn       Event handler method called to report keyboard state after each complete scan.
     */
    template <class T>
    void attach(T *obj, typename MemberKeyPressEventHandler<T>::MemberFunction fn) {
        setHandler(new MemberKeyPressEventHandler<T>(obj, fn));
    }
    
    using KeyboardEventServer<KeyPressEventHandler>::attach;
    
    void invokeHandler(const KeyEvent &keypress) {
        if (this->hasHandler()) {
            this->handler()->handleKeyPress(keypress);
        }
    }
};

} // kbd_mgr

#endif // KEYPRESS_EVENT_SERVER_H_
