#ifndef KEYBOARD_EVENT_SERVER_H_
#define KEYBOARD_EVENT_SERVER_H_

#include <cstdlib>

namespace kbd_mgr {

template <class HandlerClass>
class KeyboardEventServer {
protected:
    KeyboardEventServer() : handler_(NULL), ownHandler_(false) { }

    ~KeyboardEventServer()
    {
        clearHandler();
    }
    
    void setHandler(HandlerClass *h, bool owner = true) {
        this->handler_ = h;
        this->ownHandler_ = owner;
    }
    
    void clearHandler() {
        if (this->ownHandler_) {
            delete this->handler_;
        }
        this->handler_ = NULL;
        this->ownHandler_ = false;
    }

    HandlerClass *handler() const { return this->handler_; }

    bool hasHandler() const { return this->handler_ != NULL; }
    
public:
    void attach(HandlerClass *handler) {
        setHandler(handler, false);
    }
    void attach(HandlerClass &handler) {
        setHandler(&handler, false);
    }
    
    void detach() {
        clearHandler();
    }

private:
    HandlerClass *handler_;
    bool ownHandler_;
};

} // kbd_mgr

#endif // KEYBOARD_EVENT_SERVER_H_
