#include "system_states.hpp"
#include "system.hpp"
#include "display_manager.hpp"
#include "dtmf_generator.hpp"
#include <iostream>

float SendingState::ToneTime = 1.0;
float SendingState::PauseTime = 0.25;

namespace {
    DigitalOut toneLed(LED3);
    DigitalOut pauseLed(LED4);
}

void SendingState::enterState() {
    system()->moveCursorTo(0);
    
    DisplayManager *display = system()->display();
    display->hideCursor();
    display->writeStatus("Sending...");

    toneLed = 0;
    pauseLed = 0;
    
    playSymbol();
}

void SendingState::handleKey(char key) {
    this->timer.detach();
    pauseLed = 0;

    system()->dtmf()->stop();
    toneLed = 0;

    system()->setState(System::Edit);
}

void SendingState::playSymbol() {
    std::cout << "Sending: Play @" << system()->cursor() << "/" << system()->text_size() << "\r" << std::endl;
    DisplayManager *display = system()->display();
    display->moveTo(system()->cursor());
    display->showCursor();

    char symbol = system()->text().at(system()->cursor());
    system()->dtmf()->play(symbol);
    
    toneLed = 1;
    
    this->timer.attach(this, &SendingState::endSymbol, ToneTime);
}

void SendingState::endSymbol() {
    std::cout << "Sending: End @" << system()->cursor() << "/" << system()->text_size() << "\r" << std::endl;
    system()->dtmf()->stop();
    
    toneLed = 0;
    
    if (system()->cursor() < system()->text_size()-1) {
        this->timer.attach(this, &SendingState::nextSymbol, PauseTime);
        pauseLed = 1;
    }
    else {
        DisplayManager *display = system()->display();
        display->hideCursor();

        system()->moveCursorBy(1);

        //                    1234567890123456
        display->writeStatus("Done sending...");
    }
}

void SendingState::nextSymbol() {
    std::cout << "Sending: Next @" << system()->cursor() << "/" << system()->text_size() << "\r" << std::endl;
    
    pauseLed = 0;
    
    system()->moveCursorBy(1);
    playSymbol();
}
