#include "mbed_keyboard_manager.hpp"
#include <iostream>

using namespace kbd_mgr;

namespace {
    PinName outPinsArray[4] = { p8, p7, p6, p5 };
    KeyboardMonitor::OutPinsSet outPins(&outPinsArray[0], &outPinsArray[4]);

    
    KeyMap makeKeymap()
    {
        KeyMap keymap("123A456B789C*0#D");
        keymap(kbd_mgr::KeyEvent::LongKeyPress, 12, '@')
            (kbd_mgr::KeyEvent::LongKeyPress, 14, '$');
        return keymap;
    }

}

MbedKeyboardManager::MbedKeyboardManager() :
    keyMonitor(Port0, 4, 15, outPins), changeMonitor(), keyPressMonitor(),
    longKeyPressMonitor(), keyMapper(makeKeymap())
{
    std::cout << "Init Keyboard" << "\r" << std::endl;     
    longKeyPressMonitor.autoRepeat(0.500,0.250)(0,15);
    longKeyPressMonitor.longKeyPress(0.500)(12)(14);
}

void MbedKeyboardManager::attach(KeyHandler *handler)
{
    std::cout << "Attach Keyboard" << "\r" << std::endl;     

    this->handler = handler;
    
    keyMapper.attach(this);
    longKeyPressMonitor.attach(keyMapper);
    keyPressMonitor.attach(longKeyPressMonitor);
    changeMonitor.attach(keyPressMonitor);
    keyMonitor.attach(changeMonitor);

    keyMonitor.start();
}
    
void MbedKeyboardManager::detach()
{
    std::cout << "Detach Keyboard" << "\r" << std::endl;     
    
    keyMonitor.stop();
    
    keyMapper.detach();
    longKeyPressMonitor.detach();
    changeMonitor.detach();
    keyMonitor.detach();
}

void MbedKeyboardManager::handleKeyPress(const KeyEvent &keypress)
{
    if (keypress.event != KeyEvent::KeyPress && keypress.event != KeyEvent::RepeatedKeyPress && keypress.event != KeyEvent::LongKeyPress) {
        return;
    }
    
    if (keypress.keyChar != 0) {
        std::cout << "Handle Key '" << keypress.keyChar << "'\r" << std::endl;     
        this->handler->handleKey(keypress.keyChar);
    }
}
