#ifndef _MBED_DTMF_GENERATOR_HPP
#define _MBED_DTMF_GENERATOR_HPP

#include "dtmf_generator.hpp"

#include "snd_wave_generator/SoundWaveGenerator.h"
#include "snd_wave_generator/Wave.h"

#include <memory>

class MbedDtmfGenerator : public DtmfGenerator {
public:
    MbedDtmfGenerator();
    
    virtual void play(char ch);
    virtual void stop();
    
private:
    void makeWaves();
    void makeKeyWave(int pos, int row, int col);
    snd_wave_generator::Wave * getWaveFor(char ch);
    
    snd_wave_generator::SoundWaveGenerator generator;
    std::auto_ptr<snd_wave_generator::Wave> rowWaves[4];
    std::auto_ptr<snd_wave_generator::Wave> colWaves[4];
    std::auto_ptr<snd_wave_generator::Wave> waves[16];
};

#endif