#include "system_states.hpp"
#include "system.hpp"
#include "display_manager.hpp"

void EditState::enterState() {
    DisplayManager *display = system()->display();
    display->hideCursor();
    display->writeStatus("Edit: <*>Cmd");
    updateText();
}

void EditState::handleKey(char key)
{
    if (key == '@') {
        system()->setState(System::Command);
    }
    else if (key == '$') {
        // ignored for the time being
    }
    else {
        handleSymbol(key);
    }
}

void EditState::handleSymbol(char ch) const {
    system()->insertSymbol(ch);
    updateText();
}

