#ifndef _DISPLAY_INTERFACE_HPP
#define _DISPLAY_INTERFACE_HPP

#include <string>

class DisplayManager {
public:
    virtual void moveTo(std::size_t pos) = 0;
    virtual void writeStatus(const std::string &text) = 0;
    virtual void writeText(const std::string &text) = 0;
    virtual void showCursor() = 0;
    virtual void hideCursor() = 0;
    virtual void clear() = 0;
    
    virtual ~DisplayManager() {}
};

#endif