#ifndef WAVE_H_
#define WAVE_H_

#include <cstddef>

namespace snd_wave_generator {

/**
 * @brief Interface of a playable sound wave.
 * Waves are processed in two phases.
 * Before sending out signal, the wave is "prepared" for the generator sample rate.
 * Once the preparation is done, the generator will repeatedly "read" the wave samples.
 * The sample position is measured in samples.
 */
class Wave {
public:
    virtual void prepare(std::size_t sampleRate) = 0;
    virtual float read(std::size_t pos) const = 0;
};

} // snd_wave_generator

#endif // WAVE_H_
