#ifndef SINGLE_KEY_PRESS_MONITOR_H_
#define SINGLE_KEY_PRESS_MONITOR_H_

#include "kbd_mgr/KeyPressEventServer.h"
#include "kbd_mgr/KeyboardStateHandler.h"

namespace kbd_mgr {

/**
 * @brief A keyboard state change handler that reports on single keypresses.
 * It voluntarily ignores key combinations (only the first key pressed in a combo is reported).
 */ 
class SingleKeyPressMonitor : public KeyPressEventServer, public KeyboardStateHandler {
public:
    SingleKeyPressMonitor() : 
        lastReportedState(), lastReportedKey(KeyEvent::NoKey) 
    { }
    
    virtual void handleState(const KeyboardState &newState);
    
private:
    KeyboardState lastReportedState;
    int lastReportedKey;
};

} // kbd_mgr

#endif // SINGLE_KEY_PRESS_MONITOR_H_
