#ifndef KEYBOARD_STATE_EVENT_SERVER_H_
#define KEYBOARD_STATE_EVENT_SERVER_H_

#include "kbd_mgr/KeyboardEventServer.h"
#include "kbd_mgr/KeyboardStateHandler.h"

namespace kbd_mgr {

/**
 * @brief A keyboard state handler that reports only state changes.
 */    
class KeyboardStateEventServer : public KeyboardEventServer<KeyboardStateHandler> {
public:
    /**
     * @brief Attaches the monitor to a function.
     * @param fn       Event handler called to report keyboard state change.
     */
    void attach(FunctionKeyboardStateHandler::HandlerFunction fn) {
        setHandler(new FunctionKeyboardStateHandler(fn));
    }
    
    /**
     * @brief Attaches the monitor to a method of an object.
     * @param obj      Event handler object
     * @param fn       Event handler method called to report keyboard state after each complete scan.
     */
    template <class T>
    void attach(T *obj, typename MemberKeyboardStateHandler<T>::MemberFunction fn) {
        setHandler(new MemberKeyboardStateHandler<T>(obj, fn));
    }
    
    using  KeyboardEventServer<KeyboardStateHandler>::attach;
    
    void invokeHandler(const KeyboardState &state) {
        if (this->hasHandler()) {
            this->handler()->handleState(state);
        }
    }
};

} // kbd_mgr

#endif // KEYBOARD_STATE_EVENT_SERVER_H_
