#ifndef _MBED_KEYBOARD_MANAGER_HPP
#define _MBED_KEYBOARD_MANAGER_HPP

#include "keyboard_manager.hpp"
#include "kbd_mgr/KeyboardManager.h"

class MbedKeyboardManager : public KeyboardManager, public kbd_mgr::KeyPressEventHandler {
public:
    MbedKeyboardManager();
    
    virtual void attach(KeyHandler *handler);    
    virtual void detach();
    
private:
    virtual void handleKeyPress(const kbd_mgr::KeyEvent &event);
    
    kbd_mgr::KeyboardMonitor keyMonitor;
    kbd_mgr::KeyboardStateChangeMonitor changeMonitor;
    kbd_mgr::SingleKeyPressMonitor keyPressMonitor;
    kbd_mgr::LongKeyPressMonitor longKeyPressMonitor;
    kbd_mgr::KeyMapper keyMapper;
    
    KeyHandler *handler;
};

#endif