#include "mbed_dtmf_generator.hpp"
#include "snd_wave_generator/SineWave.h"
#include "snd_wave_generator/WaveCombo.h"
#include <iostream>
#include <sstream>
#include <string>

using namespace snd_wave_generator;

MbedDtmfGenerator::MbedDtmfGenerator() :
    generator(16000)
{
    std::cout << "Init Wave" << "\r" << std::endl;     
    makeWaves();
}

void MbedDtmfGenerator::makeKeyWave(int pos, int row, int col)
{
    std::cout << "Init Key Wave #" << pos << " R" << row << "C" << col << "\r" << std::endl;     
    std::auto_ptr<WaveCombo> wave(new WaveCombo());
    wave->add(colWaves[col].get());
    wave->add(rowWaves[row].get());
    
    waves[pos] = wave;
}

void MbedDtmfGenerator::makeWaves()
{
    static int colFreq[4] = { 1209, 1336, 1477, 1633 };
    static int rowFreq[4] = { 697, 770, 852, 941 };
    
    for(int i = 0; i < 4; ++i) {
        std::cout << "Init ColWave " << i << " hz=" << colFreq[i] << "\r" << std::endl;     
        colWaves[i].reset(new SineWave(colFreq[i]));
        
        std::cout << "Init RowWave " << i << " hz=" << rowFreq[i] << "\r" << std::endl;     
        rowWaves[i].reset(new SineWave(rowFreq[i]));
    }

    makeKeyWave(0, 3, 1);    
    for(int row = 0; row < 3; ++row) {
        for(int col = 0; col < 3; ++col) {
            makeKeyWave(row * 3 + col + 1, row, col);
        }
    }
    for(int ltr=0; ltr < 4; ++ltr) {
        makeKeyWave(ltr+10, ltr, 3);
    }
    makeKeyWave(14, 3, 0);
    makeKeyWave(15, 3, 2);
}

Wave * MbedDtmfGenerator::getWaveFor(char ch)
{
    int index = -1;
    if (ch >= '0' && ch <= '9') {
        index = ch - '0';
    }
    else if (ch >= 'A' && ch <= 'D') {
        index = ch - 'A' + 10;
    }
    else if (ch == '*') {
        index = 14;
    }
    else if (ch == '#') {
        index = 15;
    }
    std::cout << "Wave for '" << ch << "' => " << index << "\r" << std::endl;
    return this->waves[index].get();
}

void MbedDtmfGenerator::play(char ch) 
{
    Wave *wave = getWaveFor(ch);
    std::cout << "Play Wave '" << ch << "'" << "\r" << std::endl; 
    if (wave) {    
        generator.play(getWaveFor(ch));
    }
    else {
        std::cout << "No wave !\r" << std::endl;
    }
}

void MbedDtmfGenerator::stop() 
{
    std::cout << "Stop Wave" << "\r" << std::endl;     
    generator.stop();
}
