#ifndef _MBED_DISPLAY_INTERFACE_HPP
#define _MBED_DISPLAY_INTERFACE_HPP

#include "display_manager.hpp"
#include "ext_text_lcd/TextLCD.h"

class MbedDisplayManager : public DisplayManager {
public:
    MbedDisplayManager();
    
    virtual void moveTo(std::size_t pos);
    virtual void writeStatus(const std::string &text);
    virtual void writeText(const std::string &text);
    virtual void showCursor();
    virtual void hideCursor();
    virtual void clear();
    
private:
    void writeAt(std::size_t row, const std::string &text);
    void updateCursor();

    ext_text_lcd::TextLCD lcd;
    std::size_t pos;
};

#endif