#include "system_states.hpp"
#include "system.hpp"
#include "display_manager.hpp"

void InteractiveState::updateText() const {
    DisplayManager *display = system()->display();
    display->hideCursor();
    display->writeText(system()->text());
    
    updateCursor();
}

void InteractiveState::updateCursor() const {
    DisplayManager *display = system()->display();
    display->moveTo(system()->cursor());
    display->showCursor();
}
