#include "system_states.hpp"
#include "display_manager.hpp"

void InitState::enterState() {
    DisplayManager *display = system()->display();
    display->clear();
    display->hideCursor();
    display->writeStatus("DTMF-Kit v1.0");
    display->writeText(__DATE__ " / " __TIME__);
    wait(2);
}

void InitState::exitState() {
    DisplayManager *display = system()->display();
    display->clear();
    display->hideCursor();
}
