#ifndef KEYBOARD_STATE_HANDLER_H_
#define KEYBOARD_STATE_HANDLER_H_

#include "kbd_mgr/KeyboardState.h"

namespace kbd_mgr {

/**
 * @brief Interface used to report a keyboard state.
 */
class KeyboardStateHandler {
public:
    virtual void handleState(const KeyboardState &newState) = 0;
    virtual ~KeyboardStateHandler() { }
};

template <class T>
class MemberKeyboardStateHandler : public KeyboardStateHandler {
public:
    typedef void (T::*MemberFunction)(const KeyboardState &);
    
    MemberKeyboardStateHandler(T *obj, MemberFunction fn) :
        object(obj), func(fn)
    { }
    
    virtual void handleState(const KeyboardState &newState) {
        (object->*func)(newState);
    }
    
private:
    T *object;
    MemberFunction func;
};

class FunctionKeyboardStateHandler : public KeyboardStateHandler {
public:
    typedef void (*HandlerFunction)(const KeyboardState &);

    FunctionKeyboardStateHandler(HandlerFunction fn) :
        func(fn)
    { }

    virtual void handleState(const KeyboardState &newState) {
        func(newState);
    }
        
private:
    HandlerFunction func;
};

} // kbd_mgr

#endif // KEYBOARD_STATE_HANDLER_H_
