#include "mbed_display_manager.hpp"
#include <iostream>

using namespace ext_text_lcd;

MbedDisplayManager::MbedDisplayManager() :
    lcd(p28, p27, Port2, 0, TextLCD::LCD16x2), pos(0)
{
    std::cout << "Init Display" << "\r" << std::endl;     
}

void MbedDisplayManager::moveTo(std::size_t pos) 
{
    std::cout << "Display moveTo " << pos << "\r" << std::endl;
    this->pos = pos;
    updateCursor();
}

void MbedDisplayManager::writeStatus(const std::string &text)
{
    std::cout << "Display write status '" << text << "'\r" << std::endl;
    writeAt(0, text);
}

void MbedDisplayManager::writeText(const std::string &text)
{
    std::cout << "Display write text '" << text << "'\r" << std::endl;
    writeAt(1, text);
}

void MbedDisplayManager::writeAt(std::size_t row, const std::string &text)
{
    std::size_t len = text.size();
    std::string str = (text + std::string(20 - len, ' '));
    lcd.locate(0, row);
    lcd.printf(str.c_str());
    updateCursor();
}
    
void MbedDisplayManager::updateCursor()
{
    lcd.locate(pos, 1);
}

void MbedDisplayManager:: showCursor()
{
    std::cout << "Display showCursor" << "\r" << std::endl;     
    lcd.setDisplayControl(TextLCD::DisplayOn, TextLCD::CursorOn, TextLCD::BlinkingCursor);
}

void MbedDisplayManager:: hideCursor()
{
    std::cout << "Display hideCursor" << "\r" << std::endl;     
    lcd.setDisplayControl(TextLCD::DisplayOn, TextLCD::CursorOff);
}

void MbedDisplayManager:: clear()
{
    std::cout << "Display clear" << "\r" << std::endl;     
    lcd.cls();
}
