#ifndef _SYSTEM_STATES_HPP
#define _SYSTEM_STATES_HPP

#include "state.hpp"
#include "system.hpp" // for System::StateId

#include "mbed.h" // for Timeout

class StateBase : public State {
protected:
    StateBase(System::StateId id, System *system);
    virtual ~StateBase();
    
public:
    System * system() const { return this->system_; }
    
private:
    System *system_;
};

class InitState : public StateBase {
public:
    InitState(System *system) : StateBase(System::Init, system) { }
    
    virtual void enterState();
    virtual void exitState();
};

class InteractiveState : public StateBase {
public:
    InteractiveState(System::StateId id, System *system) : StateBase(id, system) { }

protected:
    void updateText() const;
    void updateCursor() const;
};

class EditState : public InteractiveState {
public:
    EditState(System *system) : InteractiveState(System::Edit, system) { }

    virtual void enterState();

    virtual void handleKey(char key);

private:
    void handleSymbol(char ch) const;
};

class CommandState : public InteractiveState {
public:
    CommandState(System *system) : InteractiveState(System::Command, system) { }

    virtual void enterState();
    virtual void exitState();

    virtual void handleKey(char key);

private:
    void handleLeft() const;
    void handleRight() const;
    void handleHome() const;
    void handleEnd() const;
    void handleDelete() const;
    void handleBackSpace() const;
    void handleClear() const;
    void handleSend() const;
    void handleHelp();
    
    void showNextStatusMsg();
    void showStatusMsg(int index);
    
    int statusMsgIndex;
    Timeout statusMsgTimeout;
};

class SendingState : public StateBase {
public:
    SendingState(System *system) : StateBase(System::Sending, system) { }

    virtual void enterState();

    virtual void handleKey(char key);
    
private:
    void playSymbol();
    void endSymbol();
    void nextSymbol();

    static float ToneTime;
    static float PauseTime;

    Timeout timer;    
};

#endif