#ifndef _SYSTEM_HPP
#define _SYSTEM_HPP

#include "key_handler.hpp"
#include <string>

class State;
class DisplayManager;
class KeyboardManager;
class DtmfGenerator;


class System : public KeyHandler {
public:
    enum StateId { 
        Init, Edit, Command, Sending,
        NumStates
    };

    System(DisplayManager *display, KeyboardManager *keyboard, DtmfGenerator *dtmf);

    DisplayManager *display() { return this->display_; }
    KeyboardManager *keyboard() { return this->keyboard_; }
    DtmfGenerator *dtmf() { return this->dtmf_; }
        
    void registerState(StateId id, State *state);
    void unregisterState(State *state);
    
    void setState(StateId newState);
    State * state() const { return this->state_; }

    void insertSymbol(char ch);
    void deleteCurrentSymbol();
    void clearText();
    const std::string &text() const { return this->text_; }
    std::size_t text_size() const { return this->len_; }
    
    void moveCursorTo(int pos);
    void moveCursorBy(int delta);
    std::size_t cursor() const { return this->pos_; }
    
    // KeyHandler implementation
    virtual void handleKey(char ch);
     
private:
    void setCursorPosition(int pos);
    
    DisplayManager *display_;
    KeyboardManager *keyboard_;
    DtmfGenerator *dtmf_;

    State *state_;
    State *states_[NumStates];

    std::string text_;
    std::size_t len_;
    std::size_t pos_;
};

#endif
