#include "mbed_display_manager.hpp"
#include "mbed_keyboard_manager.hpp"
#include "mbed_dtmf_generator.hpp"
#include "system.hpp"
#include "system_states.hpp"
#include <iostream>

int main() {
    std::cout << "\r\n\nDTMF-Kit " __DATE__ " / " __TIME__ "\r" << std::endl;
    
    MbedDisplayManager display;
    MbedKeyboardManager keyboard;
    MbedDtmfGenerator dtmf;

    System system(&display, &keyboard, &dtmf);
    InitState initState(&system);
    EditState editState(&system);
    CommandState commandState(&system);
    SendingState sendingState(&system);
    
    keyboard.attach(&system);
    
    system.setState(System::Edit);
    
    while (true) {
        wait(10);
    }
}
