#ifndef SOUND_WAVE_GENERATOR_H_
#define SOUND_WAVE_GENERATOR_H_

#include "snd_wave_generator/Wave.h"
#include "mbed.h"

namespace snd_wave_generator {

/**
 * @brief A class to handle computed sound wave generation.
 * The generator is bound to an AnalogOut pin (p18 on LPC1768).
 * It has a fixed sample rate.
 */
class SoundWaveGenerator {
public:
    SoundWaveGenerator(std::size_t sampleRate, PinName pin = p18) : 
        sampleRate(sampleRate), wave(NULL), pos(0), output(pin), ticker()
    { }
    
    /**
     * @brief Starts playing a given wave.
     * The wave will be prepared for the generator's sample rate and then played back
     * on the bound analog output.
     */
    void play(Wave *wave);
    
    /**
     * @brief Stops playing.
     */
    void stop();
    
private:
    void tickerHandler();
    
    std::size_t sampleRate;
    
    Wave *wave;    
    std::size_t pos;
    AnalogOut output;
    Ticker ticker;
};
  
} // snd_wave_generator
  
#endif // SOUND_WAVE_GENERATOR_H_
