#ifndef KEYBOARD_STATE_CHANGE_MONITOR_H_
#define KEYBOARD_STATE_CHANGE_MONITOR_H_

#include "kbd_mgr/KeyboardStateEventServer.h"
#include "kbd_mgr/KeyboardState.h"

namespace kbd_mgr {

/**
 * @brief A keyboard state handler that reports only state changes.
 */    
class KeyboardStateChangeMonitor : public KeyboardStateEventServer, public KeyboardStateHandler {
public:
    virtual void handleState(const KeyboardState &newState);
    
private:
    KeyboardState lastState;
};

} // kbd_mgr

#endif // KEYBOARD_STATE_CHANGE_MONITOR_H_
