#include "kbd_mgr/SingleKeyPressMonitor.h"

namespace kbd_mgr {

void SingleKeyPressMonitor::handleState(const KeyboardState &newState)
{
    int key;
    if (newState.getKeyPressType(key) == KeyboardState::SingleKeyPress && this->lastReportedState.empty()) 
    {
        KeyEvent keyDown(key, KeyEvent::KeyDown);
        invokeHandler(keyDown);
        
        this->lastReportedState = newState;
        this->lastReportedKey = key;
    }
    else if (!this->lastReportedState.empty() &&
             (newState & this->lastReportedState).empty())
    {
        KeyEvent keyUp(this->lastReportedKey, KeyEvent::KeyUp);
        invokeHandler(keyUp);
                
        this->lastReportedState.clear();
        this->lastReportedKey = KeyEvent::NoKey;
    }

}

} // kbd_mgr