#include "mbed.h"

Serial pc(PA_2, PA_3);
BusOut motorCoils(PB_1, PA_7, PA_6, PA_5);

void delayV(uint8_t count){
    for(unsigned char i=0; i<count; i++){
        wait(0.005);
    }
}
void step_left(int pause){
    motorCoils = 0x09;
    delayV(pause);
    motorCoils = 0x08;
    delayV(pause);
    motorCoils = 0x0C;
    delayV(pause);
    motorCoils = 0x04;
    delayV(pause);
    motorCoils = 0x06;
    delayV(pause);
    motorCoils = 0x02;
    delayV(pause);
    motorCoils = 0x03;
    delayV(pause);
    motorCoils = 0x01;
    delayV(pause);
}

void step_right(int pause){
    motorCoils = 0x01; //0001
    delayV(pause);
    motorCoils = 0x03; //0011
    delayV(pause);
    motorCoils = 0x02; //0010
    delayV(pause);
    motorCoils = 0x06; //0110
    delayV(pause);
    motorCoils = 0x04; //0100
    delayV(pause);
    motorCoils = 0x0C; //1100
    delayV(pause);
    motorCoils = 0x08; //1000
    delayV(pause);
    motorCoils = 0x09; //1001
    delayV(pause);
}

uint8_t pause = 15;
int main(){
    while(1) {
        if(pc.readable()){
            char cmd = pc.getc();
            switch(cmd){
                case 's':
                    step_right(pause);
                    pc.printf("Stepped right\n");
                break;
                
                case 'r':
                    step_right(pause);
                    pc.printf("Rotating right\n");
                break;
                
                case 'l':
                    step_left(pause);
                    pc.printf("Rotating left\n");
                break;
            }
        }
        
    }
} 