#ifndef _INCLUDED_AMT212_H_
#define _INCLUDED_AMT212_H_
#include "mbed.h"

#define SEND 1
#define RECEIVE 0
#define RECEIVE_COUNT 0
#define RECEIVE_TURN 2
#define GET_COUNT 84
#define GET_TURN 85
#define RESOLUTION_AMT21 16384
#define DETECT_FLOW 5
#define RESET 86
#define COUNT_OFFSET 6890
#define GEER_STEER 1
#ifndef M_PI
#define M_PI 3.14159265359f
#endif



class Amt21
{
private:
//////////////////////////////////////////////
    int low_count,high_count;
    int low_turn,high_turn;
    int receive_mode;
    int instruction;
    void sendMessage();
    void receiveMessage();
/////////////////////////////////////////////
    int count_;
    int receive_old;
    int flow_count;
    int th_min;
    int th_max;
    int pre_count;
    double omega_;
    double pre_time;

    int getAbCount();//カウント数取得関数
    int getTurn();//回転回数取得関数

protected:
    Serial serial_;//RS485通信
    DigitalOut  rs485_mode;//送受信の切り替え
public:
    Amt21(PinName tx,PinName rx,PinName mode);//コンストラクタ

    Timer timer_;

    void rewriteCount_1();//１周期に１度呼び出す。
    void rewriteCount_2();//１周期に１度呼び出す。
    int getCount();//インクリメント型のカウントと同じように使えて、-のカウントや16383以上のカウントを返す。
    double getDeg();//角度[°]を返す
    double getRad();//角度[rad]を返す
    void calOmega();//getOmegaする前に呼び出す
    double getOmega();//角速度[rad/s]を返す
    void reset();//回転数のリセット関数。※0～360を示すカウント数はリセットされない。

};
#endif