#include "mbed.h"
#include "USBHID.h"


//Definicion de los buffer de envio y recepcion 
USBHID hid(8,8);

//Reportes de envio  
HID_REPORT recv_report;
HID_REPORT send_report;


//Definicion del bus para PORTS
BusInOut PA(p30,p29,p28,p27,p26,p25,p24,p23);
BusInOut PB(p5,p6,p7,p8,p9,p10,p11,p12);

//Declaracion de los pines analogicos
AnalogIn ana0(p17);
AnalogIn ana1(p19);
AnalogIn ana2(p20);

//Declaracion de PWM
PwmOut PWM0(LED1);
PwmOut PWM1(LED2);
PwmOut PWM2(LED3);
PwmOut PWM3(LED4);


//Variables para el seccionamiento de los analogicos
uint8_t an0div[2];
uint8_t an1div[2];
uint8_t an2div[2];

int main(void) {

//Buffer para guardar los analogicos en lectura
uint16_t ana0buff = 0;
uint16_t ana1buff = 0;
uint16_t ana2buff = 0;

send_report.length = 8;
recv_report.length = 8;

while (1) 
{ 

    
    //Seleccioanador de caso para Bus IN/OUT en PA
    if (hid.readNB(&recv_report)) 
    {
        if(recv_report.data[0]==1)
        {
            PA.output();
            PA.write(recv_report.data[1]) ;
        }
        else
        {
            PA.input();
            send_report.data[0] = PA.read();
            hid.send(&send_report); 
        }
        
        
        
            if(recv_report.data[6]==1)
        {
            PB.output();
            PB.write(recv_report.data[7]) ;
        }
        else
        {
            PB.input();
            send_report.data[7] = PB.read();
            hid.send(&send_report); 
        }
        

        
        
    }
    //Lectura del 1er Analogico
    if (ana0.read() != ana0buff) 
    {
        ana0buff = ana0.read()*4096;
        an0div[0]=ana0buff & 0xff;
        an0div[1]=(ana0buff >> 8);
        send_report.data[1] = an0div[0];
        send_report.data[2] = an0div[1];
        hid.send(&send_report);
    }
    
    //Lectura del 2do Analogico
    if (ana1.read() != ana1buff) 
    {
        ana1buff = ana1.read()*4096;
        an1div[0]=ana1buff & 0xff;
        an1div[1]=(ana1buff >> 8);
        send_report.data[3] = an1div[0];
        send_report.data[4] = an1div[1];
        hid.send(&send_report);
    }

    //Lectura del 3er Analogico
    if (ana2.read() != ana2buff) 
    {
        ana2buff = ana2.read()*4096;
        an2div[0]=ana2buff & 0xff;
        an2div[1]=(ana2buff >> 8);
        send_report.data[5] = an2div[0];
        send_report.data[6] = an2div[1];
        hid.send(&send_report);
    }
    
        PWM0.write(float(recv_report.data[2])/255);
        PWM1.write(float(recv_report.data[3])/255);
        PWM2.write(float(recv_report.data[4])/255);
        PWM3.write(float(recv_report.data[5])/255); 
    
    }
   
}