#include "mbed.h"
#include "Adafruit_SSD1306.h"
#include "DS1307.h"
#include "SHTx/sht15.hpp"
#include "L3GD20.h"
#include "LSM303DLHC.h"
#include "BMP180.h"
#include "MS5803.h"

I2C myI2C(p9,p10);
Adafruit_SSD1306_I2c o(myI2C,D13,0x7A,64,128);
Serial pc(USBTX,USBRX);

RtcDs1307 gRtc ( myI2C );
DateTime dt;

SHTx::SHT15 sensor(p22, p21);

L3GD20 gyro(p9, p10);
LSM303DLHC compass(p9, p10);
float ax, ay, az;
float mx, my, mz;
float gx, gy, gz;
double yaw,pitch,roll;
#define     M_PI   3.14159265358979323846

BMP180 bmp180(&myI2C);
int press;
float temp;

AnalogIn uv(p20);
float uv_rad=0;
DigitalOut gato(p25);
DigitalOut reset(p26);
MS5803     press_sensor( p9, p10, 0x76);


int main(){

    sensor.setOTPReload(false);
    sensor.setResolution(true);

    
    
    
    while(1)
    {       bmp180.init();
            compass.read(&ax, &ay, &az, &mx, &my, &mz);
            gyro.read(&gx, &gy, &gz);
            roll=atan2(ay, az);
            pitch=atan((-ax)/(ay*sin(roll)+az*cos(roll)));
            yaw=atan2(mz*sin(roll)-my*cos(roll),mx*cos(pitch)+my*sin(pitch)*sin(roll)+mz*sin(pitch)*cos(roll));
           // printf("acc: %.4f %.4f %.4f mag: %.4f %.4f %.4f gir: %.4f %.4f %.4f\n\r",ax,ay,az,mx,my,mz,gx,gy,gz);
            
            press_sensor.Barometer_MS5803();
            bmp180.startTemperature();
            wait_ms(5);     // Wait for conversion to complete
            if(bmp180.getTemperature(&temp) != 0) {
            printf("Error getting temperature\n");
           continue;
           }
           bmp180.startPressure(BMP180::ULTRA_LOW_POWER);
            wait_ms(10);    // Wait for conversion to complete
            if(bmp180.getPressure(&press) != 0) {
           printf("Error getting pressure\n");
           continue;
            }
            
            uv_rad=((uv.read()*3.3)-1)/0.125;
            
            sensor.update();
            dt = gRtc.now();
            o.setTextCursor(0,0);
            o.clearDisplay();
            o.printf("%u/%u/%02u %2u:%02u:%02u\n\r",dt.month(),dt.day(),dt.year(),(dt.hour()-6),dt.minute(),dt.second());
            o.printf("Temperatura: %3.1f\r\n", sensor.getTemperature());
            o.printf("Humedad: %3.2f %%\r\n", sensor.getHumidity());
            o.printf("P=%d Pa\n\rT=%.2fC\n\r", press, temp);
            o.printf("r:%.1fp:%.1fy:%.1f\n\r",roll*180/M_PI,pitch*180/M_PI,yaw*180/M_PI);
            o.printf("UV=%.3fmW/cm^2\n\r",uv_rad);
            o.printf("P=%.0fPa T=%.2fC\r\n", press_sensor.MS5803_Pressure()*100,press_sensor.MS5803_Temperature());
            //o.fillCircle(125,61,2,1);
            //o.drawCircle(118,61,2,1);
            //o.fillCircle(111,61,2,1);
            //o.drawCircle(104,61,2,1);
            //o.fillCircle(97,61,2,1);
            o.display();
        
    }
 



 



   
 

 }