#include "mbed.h"
#include "DHT22.h"
 
PwmOut pulso(LED1);
Serial pc(USBTX, USBRX);
Serial blue(p13,p14);         // TX = P14  RX = P13

DigitalOut sala(p30);
DigitalOut foco(p29);
DigitalOut ventilador(p28);
DigitalOut fuente(p27);
DigitalOut jardin(p26);
Ticker cruce;
Timeout sen;
const float powerlinefrequency=60.000;
volatile float dim;
Timeout SSRtriggerOn;
AnalogIn mq2(p20);
float value = 0;
float cal=0;
float calt=0;
float Rgas,Raire;


char n;
float m=180;

float temp,hum;m

DHT22 dht22(p15) ;

void triggerOn()
{
    foco = 1;
}
 
 void dimmer()
{
    // turn off SSR at zero crossing
    foco = 0;
    // compute time delay using dim value and set timer interrupt
    // triggers SSR after a small post zero crossing time delay
    SSRtriggerOn.attach(&triggerOn,(dim)/(2*powerlinefrequency));
}
void sensado()
{       dht22.sample() ;
        temp=dht22.getTemperature();
        hum=dht22.getHumidity();
         Rgas=mq2/(3.3-mq2);
        blue.printf("%2.2f,%2.2f,%2.2f",temp/10,hum/10,(Rgas/Raire)*100);
        
        
    }

int main() 
{
        for(int x = 0 ; x < 20 ; x++)
        {
        cal = cal + mq2 ;
        wait(.1);
        
        }
        calt=(cal/20)*3.3;
 Raire=calt/(3.3-calt);
 
    cruce.attach(&dimmer, 0.00833333);
    sen.attach(&sensado, 1);
    
    blue.baud(9600);
    pc.baud(9600);
    pc.printf("Bluetooth Start\r\n");
    
    // echo back characters and toggle the LED
    while (1) 
    {
        if (blue.readable()) 
        {
            n=blue.getc();
            pc.putc(n);
            if(n=='H'){if(m<180)m=m+5;}
            if(n=='h'){if(m<180)m=m-5;}
            
            if(n=='J'){jardin=1;}
            if(n=='j'){jardin=0;}
            if(n=='C'){ventilador=1;}
            if(n=='c'){ventilador=0;}
            if(n=='F'){fuente=1;}
            if(n=='f'){fuente=0;}
            if(n=='S'){sala=1;}
            if(n=='s'){sala=0;}
            
           dim=m/180+0.001;
          
        }
        
        
     
    }
}