/////////////////////////////////////////////////////////////////////////////////////
//Libreria de la tarjeta LPC1768
#include "mbed.h"
//Libreria para control de motores a paso por pulso con easydriver
#include "stepper.h"
 /////////////////////////////////////////////////////////////////////////////////////
//Definicion del puerto serial delo cotrolador
Serial pc(USBTX,USBRX);
//Definicion de los pines para el control de eje X (Pulso, Direccion)
stepper x(p27,p28);
//Definicion del pin para activacion de ahorro de energia en eje X
DigitalOut sx(p29);
//Definicion de los pines para el control de eje Y (Pulso, Direccion)
stepper y(p24,p25);
//Definicion del pin para activacion de ahorro de energia en eje Y
DigitalOut sy(p26);
//Definicion de los pines para el control de eje Z (Pulso, Direccion)
stepper z(p21,p22);
//Definicion del pin para activacion de ahorro de energia en eje X
DigitalOut sz(p23);
//Contador para los ciclos for de pasos para ejes X, Y, Z y combinaciones(Diagonales)
int contx=0;
int conty=0;
int contz=0;
int contd=0;
//Contadot de while para diagonales
int n=0;
//COntadores de pasos generales para envio de ubicacion
int stepcx=0;
int stepcy=0;
int stepcz=0;
//Definicion de la variable para control
char control='0';
/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////

//Definicion de funcion con la resolucion adecuada de 5mm.Recibe Informacion de numero de veces y direccion
void xm(int px,int xd)
{
//Desactivacion del modo de ahorro de energia
sx=1;    
    //Definiciond el numero de veces que realizara el movimiento
    for(contx=1;contx<=px;contx++)
    {   //If para comprobar direccion
        if(xd==0)
        //Uso de la libreria para definir los pasos direccion velocidad
        //y aceleracion del pulso ademas de incremento del contador de pasos
        {x.step(5344,0,200,0);stepcx=stepcx-5344;}
        else
        {x.step(5344,1,200,0);stepcx=stepcx+5344;}
        
    }
//Activacion del modo de ahorro de energia
sx=0;
//Limpieza de contador de movimientos
contx=0;
}
//Definicion demovimientos para el eje Y 
void ym(int py,int yd)
{
sy=1;    
    for(conty=1;conty<=py;conty++)
    {
        if(yd==0)
        {y.step(6400,0,200,0);stepcy=stepcy-6400;}
        else
        {y.step(6400,1,200,0);stepcy=stepcy+6400;}
        
    }
sy=0;
conty=0;
}
//Definicion de movimientos de eje Z
void zm(int pz,int zd)
{
sz=1;    
    for(contz=1;contz<=pz;contz++)
    {
        if(zd==0)
        {z.step(5443,0,200,0);stepcz=stepcz-5443;}
        else
        {z.step(5443,1,200,0);stepcz=stepcz+5443;}
        
    }
sz=0;
contz=0;
}
// Definicion de los movimientos diagonales
void dm(int pd,int dd)
{
//Desactivacion delmodo de ahorro en dos ejes x Y
sx=1;
sy=1;    
    //Definiciond e ciclo for para la cantidad de movimiento diagonales
    for(contd=1;contd<=pd;contd++)
    {   //Bloque if para determinar el tipo de diagonal
        if(dd==0)
        //Ciclo while con moviento combinado de ejes y sus respectivas sumas a contadores de pasos
        {while(n<1000){y.step(6,1,200,0);x.step(5,0,200,0);n++;stepcx=stepcx-5;stepcy=stepcy+6;}n=0;}
        else if(dd==1) 
        {while(n<1000){y.step(6,0,200,0);x.step(5,0,200,0);n++;stepcx=stepcx-5;stepcy=stepcy-6;}n=0;}
        else if(dd==2) 
        {while(n<1000){y.step(6,1,200,0);x.step(5,1,200,0);n++;stepcx=stepcx+5;stepcy=stepcy+6;}n=0;}
        else 
        {while(n<1000){y.step(6,0,200,0);x.step(5,1,200,0);n++;stepcx=stepcx+5;stepcy=stepcy-6;}n=0;}
        
    }
sx=0;
sy=0;
contd=0;
}
//Elsiguiente bloque de subrutinas ocupa la subrutinas definidas anteriormente
//Definicion de un espaciado grande para poner entre palabras 
void ESM(){zm(1,1);sx=1;x.step(5344,0,200,0);sx=0;stepcx=stepcx-5344;zm(1,0);}
//Definicion de un espacio pequeño para la separacion entre letras
void ES(){zm(1,1);sx=1;x.step(1500,0,200,0);sx=0;stepcx=stepcx-1500;zm(1,0);}
//Definicion de movimientos para la generacion de letras con su espacio
void A(){ym(2,1);xm(1,0);ym(1,0);xm(1,1);xm(1,0);ym(1,0);ES();}
void B(){xm(1,0);ym(1,1);xm(1,1);ym(1,1);xm(1,0);ym(1,0);xm(1,1);ym(1,0);xm(1,0);ES();}
void C(){ym(2,1);xm(1,0);xm(1,1);ym(2,0);xm(1,0);ES();}
void D(){xm(1,0);dm(1,0);dm(1,2);xm(1,1);ym(2,0);zm(1,1);xm(2,0);ES();zm(1,0);}
void E(){ym(2,1);xm(1,0);xm(1,1);ym(1,0);xm(1,0);xm(1,1);ym(1,0);xm(1,0);ES();}
void F(){ym(2,1);xm(1,0);xm(1,1);ym(1,0);xm(1,0);zm(1,1);ym(1,0);ES();zm(1,0);}
void G(){ym(1,1);xm(1,0);ym(1,0);xm(1,1);ym(2,1);xm(1,0);zm(1,1);ym(2,0);ES();zm(1,0);}
void H(){ym(2,1),ym(1,0);xm(1,0);ym(1,1);ym(2,0);ES();}
void I(){zm(1,1);ES();ES();zm(1,0);ym(2,1);ym(2,0);zm(1,1);ES();zm(1,0);}
void J(){xm(1,0);ym(2,1);ym(2,0);ES();}
void K(){ym(2,1);ym(1,0);dm(1,0);dm(1,3);dm(1,1);ES();}
void L(){ym(2,1);ym(2,0);xm(1,0);ES();}
void M(){ym(2,1);dm(1,1);dm(1,0);ym(2,0);ES();}
void N(){ym(2,1);dm(2,1);ym(2,1);ym(2,0);ES();}
void O(){ym(2,1);xm(1,0);ym(2,0);xm(1,1);xm(1,0);ES();}
void P(){ym(2,1);xm(1,0);ym(1,0);xm(1,1);zm(1,1);dm(1,1);ES();zm(1,0);}
void R(){ym(2,1);xm(1,0);ym(1,0);xm(1,1);dm(1,1);ES();}
void S(){xm(1,0);ym(1,1);xm(1,1);ym(1,1);xm(1,0);zm(1,1);ym(2,0);zm(1,0);ES();}
void T(){ESM();ym(2,1);xm(1,1);xm(2,0);xm(1,1);ym(2,0);zm(1,1);xm(1,0);ES();zm(1,0);}
void U(){ym(2,1);ym(2,0);xm(1,0);ym(2,1);ym(2,0);ES();}
//En esta letra se utulizo un a relacion especial para las diagonales pot lo cual se vuelve 
//las funciones de la libreria stepper.h y ciclos for while
void V()
    {
        ESM();
        sx=1;sy=1;for(contd=1;contd<=2;contd++){while(n<1000){y.step(6,1,200,0);x.step(2,1,200,0);n++;stepcx=stepcx+2;stepcy=stepcy+6;}n=0;}sx=0;sy=0;contd=0;
        sx=1;sy=1;for(contd=1;contd<=2;contd++){while(n<1000){y.step(6,0,200,0);x.step(2,0,200,0);n++;stepcx=stepcx+2;stepcy=stepcy-6;}n=0;}sx=0;sy=0;contd=0;
        sx=1;sy=1;for(contd=1;contd<=2;contd++){while(n<1000){y.step(6,1,200,0);x.step(2,0,200,0);n++;stepcx=stepcx+2;stepcy=stepcy+6;}n=0;}sx=0;sy=0;contd=0;
        sx=1;sy=1;for(contd=1;contd<=2;contd++){while(n<1000){y.step(6,0,200,0);x.step(2,1,200,0);n++;stepcx=stepcx+2;stepcy=stepcy-6;}n=0;}sx=0;sy=0;contd=0;
        zm(1,1);ESM();ES();zm(1,0);
    }
void W(){ym(2,1);ym(2,0);dm(1,0);dm(1,1);ym(2,1);ym(2,0);ES();}
void X(){dm(2,0);dm(1,3);dm(1,2);dm(2,1);ES();}
void Z(){dm(2,0);xm(2,1);xm(2,0);dm(2,3);xm(2,0);ES();}
//Definicion de SUbrutina para retorno de carro mediante los contadores de steps y movimientos de eje z
void backx(){zm(1,1);ym(3,0);stepcx=-stepcx;sx=1;x.step(stepcx,1,200,0);sx=0;stepcx=0;zm(1,0);}
//Definicion de escritura de nombres usando las subrutinas de letras y espacios
void OSCAR(){O();S();C();A();R();ESM();D();E();ESM();J();E();S();U();S();ESM();V();}
void IKI(){I();K();I();ESM();B();A();L();A();M();ESM();R();}
void LALO(){E();D();U();A();R();D();O();ESM();A();N();T();O();N();I();O();ESM();L();}
//Definicon del rectangulo con las subrutinas anteriores
void rectangulo(){ym(8,1);xm(14,0);ym(8,0);xm(14,1);xm(14,0);ESM();}
//Definicion de triangulo con manupulacion de relacion de steps para angulos de 60° 
//con trabaja trigonometrico paratener las mismas distancias y hacerlo equilatero.
void triangulo()
    {
    xm(4,0);sx=1;sy=1;
    while(n<2223){y.step(9,1,200,0);x.step(5,1,200,0);n++;stepcx=stepcx+5;stepcy=stepcy+9;}n=0;
    while(n<2223){y.step(9,0,200,0);x.step(5,1,200,0);n++;stepcx=stepcx-5;stepcy=stepcy-9;}n=0;
    sx=0;sy=0;
    }
//Definicion de linea de 8.5 cm con las subrutinas de movimientos
void line(){xm(17,0);}
//Definicion del pentagono con manupulacion de relacion de steps para angulos de 108° y 72°
//y distancias para que cerrarar el pentagono
void penta(){
sx=1;sy=1;
while(n<9828){y.step(1,1,200,0);x.step(2,1,200,0);n++;stepcx=stepcx+2;stepcy=stepcy+1;}n=0;
while(n<2005){y.step(11,0,200,0);x.step(5,1,200,0);n++;stepcx=stepcx+5;stepcy=stepcy-11;}n=0;
while(n<2005){y.step(11,0,200,0);x.step(5,0,200,0);n++;stepcx=stepcx-5;stepcy=stepcy-11;}n=0;
while(n<9828){y.step(1,1,200,0);x.step(2,0,200,0);n++;stepcx=stepcx-2;stepcy=stepcy+1;}n=0;
sx=0;sy=0;
ym(4,1);
}
//Definicion de SUbrutina para reiniciar los contadores de steps los cuales sirven 
//para retrorno de carro y envio de ubicacion.
void origin(){stepcx=0;stepcy=0;stepcz=0;}
/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////
int main()
{
//El puerto serial por default se configura a 9600 bauds
//Se define un cilo infinito para capturar el serial constantemente
while(1)
{
//Instruccion para determinar si hay algun proveniente de la interfaz en puerto
//si si se asigna el caracter a la variable de control.
if (pc.readable()) 
        {
            control=pc.getc();
        }
//Serie condicional para determinar el caracter recibido
//por serial y determinacion de caso a realizar
//basicamente es el punto de relacion entre la interfaz y el controlador
    //Condicionales para control manual
if(control=='d'){xm(1,1);}
else if(control=='a'){xm(1,0);}
else if(control=='w'){ym(1,1);}
else if(control=='s'){ym(1,0);}
else if(control=='1'){zm(1,1);}
else if(control=='2'){zm(1,0);}
    //Condicionales para control automatico
else if(control=='l'){line();}
else if(control=='t'){triangulo();}
else if(control=='r'){rectangulo();}
else if(control=='p'){penta();}
else if(control=='n'){OSCAR();backx();IKI();backx();LALO();backx();}
    //Condicional para definir origen (Reset de  contadores)
else if(control=='o'){origin();}
//Limpieza de variable de control para evitar bucle
control='0';ts
//Escritura continua de posicion de los ejes en steps al puerto serial con espaciado para no perder
//informacion por desincronizacion de escritura-lectura.
pc.printf("--------,%i,%i,%i,-------\n",stepcx,stepcy,stepcz);

}


}