#include "mbed.h"                       //Se declara la librería de mbed

//--- O/I Pines ------------------------------------------------
AnalogIn pot(A0);                       //Se declara el puerto de entrada analócia para el potenciometro
InterruptIn botonGiro(D2);              //Se declara el puerto de entrada para el boton controlador de giro
InterruptIn botonSecuencia(D3);         //Se declara el puerto de entrada para el boton controlador de secuencia
DigitalOut salidaReloj(PTC4);           //Se declara el puerto de salida para la señal de reloj
DigitalOut salidaSecuencia(PTC3);       //Se declara el puerto de salida para el tipo de secuencia
DigitalOut salidaGiro(PTC0);            //Se declara el puerto de salida para el sentido de giro
DigitalOut led(LED1);                   //Se declara el puerto de salida para el led que indica que el programa está corriendo
Timer timer;                            //Se declara el timer


//--- Constantes ---------------------------------------------
#define MAX_FREQ 1000                   //Se define el valor de la frecuencia máxima de la señal de reloj
#define MIN_FREQ 4                      //Se define el valor de la frecuencia minima de la señal de reloj


//--- Variables -----------------------------------------------
int freq=0;                             //Se declaran la variable para guardar la frecuencia de la señal de reloj
int t=0;                                //Se declaran la variable para guardar la lectura del timer      


//--- Declaración de Funciones --------------------------------
void cambio_secuencia();                //Se declara la función para la interrupción del boton controlador de secuencia
void cambio_giro();                     //Se declara la función para la interrupción del boton controlador de sentido de giro


//--- Programa Principal --------------------------------
int main(){
    timer.start();                                  //Se inicializa el timer
    botonGiro.rise(&cambio_giro);                   //Se direcciona la funcion cambio_giro al flanco positivo del boton controlador de sentido de giro
    botonSecuencia.rise(&cambio_secuencia);         //Se direcciona la funcion cambio_giro al flanco positivo del boton controlador de secuencia
    
    while(1){                                       //Ciclo del programa principal
        freq=MIN_FREQ+(MAX_FREQ-MIN_FREQ)*pot;      //Se lee el potenciometro y se mapea la lectura al rango de frecuencias máxima y mínima
        if (t>(500/freq)){                          //Condición que se cumplirá cada medio periodo, con ella se crea la señal de reloj
            salidaReloj=!salidaReloj;               //Se cambia el estado de la salida de reloj
            timer.reset();                          //Se resetea la cuenta del timer
        }
        t=timer.read_ms();                          //Se lee el timer en milisegundos
    }
    
}

//--- Funciones --------------------------------
void cambio_secuencia(){                            //Función para la interrupción del boton controlador de secuencia
    salidaSecuencia=!salidaSecuencia;               //Se cambia el tipo de secuencia
}

void cambio_giro(){                                 //Función para la interrupción del boton controlador de sentido de giro
    salidaGiro=!salidaGiro;                         //Se cambia el sentido de giro
}