#include "mbed.h"

DigitalOut led(LED1);                       //Se declara LED1 como salida digital para identificar cuando el programa está corriendo
AnalogIn pot(A0);                           //Se declara A0 como entrada analogica para el potenciometro
PwmOut enable(PTA12);                       //Se declara PTA12 como PWM
DigitalIn button(PTD4);                     //Se declara PTD4 como entrada digital para el boton

bool freqdef=0;                             //Se define una variable booleana para los dos estados de frecuencia (1kHz y 10kHz), se inicializa en estado 0 (1kHz)
float potval=0;                             //Se defne una viariable flotante para guardar la lectura del potenciometro

Serial pc(USBTX, USBRX);                    //Se inicia comunicación serial con la computadora para visualizar el estado
                                            //de frefuencia y la lectura del potenciometro
int main()
{
    button.mode(PullUp);                    //Se define el puerto del botón como PullUp
    
    while(1) {
        
        if(button==1) {                     //Cuando el boton es presionado se entra a esta condición
            while (button==1) {             //Ciclo que estanca el programa mientras esta presionado el botón, 
                potval=pot;                 //pero sigue haciendo lectura del potenciometro y modificando el PWM
                pc.printf("%d\t",freqdef);
                pc.printf("%f\n",potval);
                enable=potval;
            }
            
            freqdef=!freqdef;               //Al soltar el botón se cambia del estado de frecuencia 0 al 1 o viceversa 
        }


        if(freqdef==0){                     //Si el estado es 0 se establece en el PWM una frecuencua de 1kHz
            enable.period_ms(1);
        }
        
        if(freqdef==1){
            enable.period_us(100);          //Si el estado es 0 se establece en el PWM una frecuencua de 10kHz
        }
        

        potval=pot;                         //Se guarda el valorer leido del potenciometro en la variable flotante potval
        pc.printf("%d\t",freqdef);          //Se imprimen en el monitor serial el numero del estado de frecuencia y la lectura del potenciometro
        pc.printf("%f\n",potval);
        enable=potval;                      //Se establece el ciclo del trabajo del PWM mediante la lectura del potenciometro

    }
}


