#include "mbed.h"
//FRDM-KL25Z CONECTED TO MATLAB 2013//
// Copyright (c) 2014 Oscar Rodriguez-- Oscargrodri@hotmail.com
/*
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

Serial pc(USBTX, USBRX);

AnalogIn ain(PTB0);

int main()
{
    while(true) {
        pc.printf(" %f ",ain.read()*5);
        wait(.1);
    }
}

/* This is the Matlab Script just copy ir as is only change the Com number
  
delete(instrfind({'Port'},{'COM8'})); %ajustar puerto serie!

    clear
    clc

    %User Defined Properties 
    serialPort = 'COM8';            % define COM port #
    plotTitle = 'Serial Data Log';  % plot title
    xLabel = 'Elapsed Time (s)';    % x-axis label
    yLabel = 'Data';                % y-axis label
    plotGrid = 'on';                % 'off' to turn off grid
    min = -1.5;                     % set y-min
    max = 6;                      % set y-max
    scrollWidth = 10;               % display period in plot, plot entire data log if <= 0
    delay = 0.001;                    % make sure sample faster than resolution

    %Define Function Variables
    time = 0;
    data = 0;
    count = 0;

    %Set up Plot
    plotGraph = plot(time,data,'-mo',...
                    'LineWidth',1,...
                    'MarkerEdgeColor','k',...
                    'MarkerFaceColor',[.49 1 .63],...
                    'MarkerSize',2);

    title(plotTitle,'FontSize',25);
    xlabel(xLabel,'FontSize',15);
    ylabel(yLabel,'FontSize',15);
    axis([0 10 min max]);
    grid(plotGrid);

    %Open Serial COM Port
    s = serial(serialPort);
    set(s,'BaudRate',9600,'Terminator','CR','Parity','None');
    disp('Close Plot to End Session');
    fopen(s);
    tic

      while ishandle(plotGraph) %Loop when Plot is Active
            dat = fscanf(s,'%f',10) %Read Data from Serial as Float
           % pause(0.1);
            if(~isempty(dat) && isfloat(dat)) %Make sure Data Type is Correct        
                count = count + 1;    
                time(count) = toc;    %Extract Elapsed Time
                data(count) = dat(1); %Extract 1st Data Element         
                testx(count)=time(count);
                testy(count)=data(count);
                %Set Axis according to Scroll Width
                if(scrollWidth > 0)
                set(plotGraph,'XData',time(time > time(count)-scrollWidth),'YData',data(time > time(count)-scrollWidth));
                axis([time(count)-scrollWidth time(count) min max]);
             
                else
                set(plotGraph,'XData',time,'YData',data);
                axis([0 time(count) min max]);
            
                end
                %Allow MATLAB to Update Plot
                pause(delay);
      
            end
        end

    %Close Serial COM Port and Delete useless Variables
    fclose(s);
    clear count dat delay max min plotGraph plotGrid plotTitle s ...
            scrollWidth serialPort xLabel yLabel data time;


    disp('Session Terminated...');
    delete(instrfind({'Port'},{'COM8'})); %ajustar puerto serie!
  plot (testx,testy)
  grid on;
  */
  