#include "mbed.h"
#include "uLCD_4DGL.h"
#include "PinDetect.h"
#include "rtos.h"
#include "Servo.h"

uLCD_4DGL uLCD(p9,p10,p11); // serial tx, serial rx, reset pin;
Serial pc(USBTX, USBRX); // tx, rx

// pb
PinDetect button1(p7,PullDown);
PinDetect button2(p8,PullDown);

// sensors
AnalogIn waterSensor(p20);
AnalogIn moistureSensor(p19);
AnalogIn lightSensor(p18);

// outputs
PwmOut speaker(p21);
PwmOut led(p22);
PwmOut led1(LED1);
// motors
Servo Shade(p23);
Servo Pipe(p24);


Mutex myMut;
volatile int button1_push = 0;
volatile int button2_push = 0;
volatile float setWaterLevel = 0.5;
volatile float setMositLevel = 0.5;
volatile float setLightLevel = 0.5;
volatile float ShadePosition = 0.0;
volatile float ShadePosition = 0.0;

volatile int counting = 0; // keep track of how many seconds has passed

// sensor readings
volatile float water = 0.0;
volatile float light = 0.0;
volatile float moist = 0.0;

// callback functinos for 2 pushbuttons
void Button1_Callback (void) {button1_push = 1;}
void Button2_Callback (void) {button2_push = 1;}

// function for the buttons thread: adjust pre-set light levels
void buttons_function(void const *argument){
    while(1){
        if (button1_push && button2_push)
        {
            uLCD.cls();
            uLCD.printf("DON'T PRESS THE BUTTON AT THE SAME TIME!\n\r");
            button1_push = button2_push = 0;
            uLCD.cls();
        }
        if (button1_push)
        {
            setLightLevel -= .1;
            button1_push = 0;
        }
        if (button2_push)
        {
            setLightLevel += .1;
            button2_push = 0;
        }
        if (setLightLevel<0) setLightLevel = 0;
        if (setLightLevel>1) setLightLevel = 1;

        myMut.lock();
        uLCD.locate(0,10);
        uLCD.printf("SetLightLevel: %1.1f\n\r", setLightLevel);
        myMut.unlock();
        Thread::wait(500);
    }    
}

// move the servos, also light an LED
void motors_function(void const *argument){
    while(1){
        shadePosition = 1-light; // raise the shade when light 
        Shade = shadePosition);
        led.write(shadePosition)
        
        pipePosition = soil<0.6? 1:0;
        pipe = pipePosition;
        Thread::wait(1000);
    }
}    

int main() {
    uLCD.printf("\n\rstart printing\n");
    uLCD.cls();
    speaker.period(1.0/800.0);

    button1.attach_deasserted(&Button1_Callback);
    button1.setSampleFrequency();
    button2.attach_deasserted(&Button2_Callback);
    button2.setSampleFrequency();

    Thread buttons(buttons_function);
    Thread motors(motors_function);

    while(1) {
        water = waterSensor.read();
        moist = moistureSensor.read();
        light = lightSensor.read();
        myMut.lock();
        uLCD.locate(0,2);
        uLCD.printf("%d:\n\r",counting);
        uLCD.printf("water: %f\n\r",water);
        uLCD.printf("moist: %f\n\r",moist);
        uLCD.printf("light: %f\n\r",light);
        myMut.unlock();
        counting++;
         
        // sound the alarm if water level too low
        speaker = water<setWaterLevel? 0.5:0;
    
        Thread::wait(1000);
    }
}