#include "mbed.h"
#include "DebouncedIn.h"
#include "stdio.h"
#include "string.h"

#define DEFAULT_TIMEOUT         5
#define SMS_MAX_LENGTH          16
#define MESSAGE_SMS             1

// DECLARACION VARIABLES
DigitalOut Led1(LED1);
DigitalOut Led2(LED2);
DigitalOut Led3(LED3);
DebouncedIn button1(PTC12);  //señal que inicia el envio del mensaje
Serial gprsSerial(PTE0,PTE1); //Configura puerto UART de la FRDMKL25Z
Serial pc(USBTX,USBRX);//Configura puerto USB a la consola serial del PC conectado.
Timer timeCnt;
char messageBuffer[SMS_MAX_LENGTH];


///////// FUNCIONES 

int readBuffer(char *buffer,int count)
{
    int i = 0;
    timeCnt.start();  // start timer
    while(1) {
        while (gprsSerial.readable()) {
            char c = gprsSerial.getc();
            if (c == '\r' || c == '\n') c = '$';
            buffer[i++] = c;
            if(i > count)break;
        }
        if(i > count)break;
        if(timeCnt.read() > DEFAULT_TIMEOUT) {
            timeCnt.stop();
            timeCnt.reset();
            break;
        }
    }
    wait(0.5);
    while(gprsSerial.readable()) {  // display the other thing..
        char c = gprsSerial.getc();
    }
    return 0;
}

void cleanBuffer(char *buffer, int count)
{
    for(int i=0; i < count; i++) {
        buffer[i] = '\0';
    }
}

void sendCmd(char *cmd)
{
    gprsSerial.puts(cmd);
}

int waitForResp(char *resp, int timeout)
{
    int len = strlen(resp);
    int sum=0;
    timeCnt.start();

    while(1) {
        if(gprsSerial.readable()) {
            char c = gprsSerial.getc();
            sum = (c==resp[sum]) ? sum+1 : 0;
            if(sum == len)break;
        }
        if(timeCnt.read() > timeout) {  // time out
            timeCnt.stop();
            timeCnt.reset();
            return -1;
        }
    }
    timeCnt.stop();                 // stop timer
    timeCnt.reset();                    // clear timer
    while(gprsSerial.readable()) {      // display the other thing..
        char c = gprsSerial.getc();
    }

    return 0;
}

int sendCmdAndWaitForResp(char *cmd, char *resp, int timeout)
{
    sendCmd(cmd);
    pc.printf("%s\r\n", cmd);
    return waitForResp(resp,timeout);
}

int powerCheck(void)
{
    return sendCmdAndWaitForResp("AT\r\n", "OK", 2);    
}

int settingSMS(void)
{
    if(0 != sendCmdAndWaitForResp("AT+CNMI=1,1\r\n", "OK", DEFAULT_TIMEOUT)) {
        return -1;
    }
    if(0 != sendCmdAndWaitForResp("AT+CMGF=0\r\n", "OK", DEFAULT_TIMEOUT)) {
        return -1;
    }
    return 0;
}

int init(void)
{
   // for(int i = 0; i < 3; i++){
        sendCmdAndWaitForResp("AT\r\n", "OK", DEFAULT_TIMEOUT);
        wait(0.5);
   // }
    
    if(0 != settingSMS()) {
        return -1;
    }
    return 0;
}

int sendSMS(char *number, char *data)
{
    char cmd[64];
    while(gprsSerial.readable()) {
        char c = gprsSerial.getc();
    }
    //snprintf(cmd, sizeof(cmd),"AT+CMGS=\"%s\"\r\n",number);
    snprintf(cmd, sizeof(cmd),"AT+CMGS=%s\r\n",number);    // ARREGLADO

    if(0 != sendCmdAndWaitForResp(cmd,">",DEFAULT_TIMEOUT)) {
        return -1;
    }
    wait(1);
    gprsSerial.puts(data);
    pc.printf("%s",data); // LO PUSIMOS******
    gprsSerial.putc((char)0x1a);
    return 0;
}

int readSMS(char *message, int index)
{
    int i = 0;
    char gprsBuffer[100];
    char *p,*s;
    gprsSerial.printf("AT+CMGR=%d\r\n",index);
    cleanBuffer(gprsBuffer,100);
    readBuffer(gprsBuffer,100);
    if(NULL == ( s = strstr(gprsBuffer,"+CMGR"))) {
        return -1;
    }
    if(NULL != ( s = strstr(gprsBuffer,"+32"))) {
        p = s + 6;
        while((*p != '$')&&(i < SMS_MAX_LENGTH-1)) {
            message[i++] = *(p++);
            pc.printf("%c",*p); //                                              ARREGLADO*****
        }
        message[i] = '\0';
    }
    return 0;
}

int deleteSMS(int index)
{
    char cmd[32];
    snprintf(cmd,sizeof(cmd),"AT+CMGD=%d\r\n",index);
    sendCmd(cmd);
    return 0;
}

int getSMS(char* message)
{
    if(NULL != messageBuffer) {
        strncpy(message,messageBuffer,SMS_MAX_LENGTH);
    }
    return 0;
}

int loopHandle(void)
{
    char gprsBuffer[100];
    int i;
    char *s = NULL;
    while(gprsSerial.readable()) {
        char c = gprsSerial.getc();
    }
    wait(0.5);
START:
    cleanBuffer(gprsBuffer,100);
    i = 0;
    while(1) {
        if(gprsSerial.readable()) {
            timeCnt.start();  // start timer
            while(1) {
                while (gprsSerial.readable()) {
                    char c = gprsSerial.getc();
                    if (c == '\r' || c == '\n') c = '$';
                    gprsBuffer[i] = c;
                    pc.printf("%c",gprsBuffer[i]); // NOSOTROS LO PUSIMOS******
                    i++;
                    if(i > 100) {
                        i = 0;
                        break;
                    }
                }
                if(timeCnt.read() > 2) {          // time out
                    timeCnt.stop();
                    timeCnt.reset();
                    break;
                }
                
            }
            break;
        }
    }
        if(NULL != (s = strstr(gprsBuffer,"+CMT"))) { //SMS: $$+CMTI: "SM",24$$
        if(NULL != (s = strstr(gprsBuffer,"+32"))) {
            s += 6;
            int i = 0;
            cleanBuffer(messageBuffer,SMS_MAX_LENGTH);
            while((*s != '$')&&(i < SMS_MAX_LENGTH-1)) {
                messageBuffer[i++] = *(s++);
               pc.printf("%c",*s); //                                              ARREGLADO*****
            }
            messageBuffer[i] = '\0';
            return MESSAGE_SMS;
        } else {
            goto START;
        }
    } else {
        goto START;
    }
}

//////// MAIN

int main(){
    
    gprsSerial.baud(9600);//configura los baudios de la FRDMKL25Z en 9600
    gprsSerial.format(8,Serial::None,1); //configura el formato de los datos de la UART
    
    Led1=Led2=Led3=1;
          
    init();
    Led1=0;
    
    loopHandle();
    
    
    while(1){

//ENVIAR
 
    if (button1.falling()){
        
        Led2=0;
        //sendSMS("20","0011000A9103218548570000AA08416650DA0C8262");
        
        }//If button1.falling
    
//RECIBIR


    
    }//While principal
} // Main


