#include "fonts.h"
#include "mbed.h"
#include "ble/BLE.h"
#include <stdbool.h>
#include <stdint.h>


DigitalOut SCLK(P0_8);
DigitalOut SDIN(P0_10);
DigitalOut RES(P0_18);
DigitalOut CS(P0_29);
DigitalOut DC(P0_28);

#define Max_Column  160
#define Max_Row     136
#define Brightness  0xcf

void oledwrite(int num1,int num2,int num3, int analog_read);

int num1;
int num2;
int num3;


void part_num(int analog_read)
{
    for(int q = 0;q<=3;q++)
    {
        int num = analog_read;
        for(int k = 0;k<3;k++)
        {
            switch(k)
            {
                case 0:
                    num3 = (num%10);
                    num = num/10;
                    break;
                case 1:
                    num2 = (num%10);
                    num = num/10;
                    break;
                case 2:
                    num1 = (num%10);
                    num = num/10;
                    break;
            }
        }
    }
    oledwrite(num1,num2,num3,analog_read);
}

void Write_Command(unsigned char Data)
{
unsigned char i;

    CS=0;
    DC=0;
    for (i=0; i<8; i++)
    {
        SCLK=0;
        SDIN=(Data&0x80)>>7;
        Data = Data << 1;
        SCLK=1;
    }
    DC=1;
    CS=1;
}


void Write_Data(unsigned char Data)
{
unsigned char i;

    CS=0;
    DC=1;
    for (i=0; i<8; i++)
    {
        SCLK=0;
        SDIN=(Data&0x80)>>7;
        Data = Data << 1;
        SCLK=1;
    }
    DC=1;
    CS=1;
}


//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//  Instruction Setting
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
void Set_Start_Column(unsigned char d)
{
    Write_Command(0x00+d%16);       // Set Lower Column Start Address for Page Addressing Mode
                                    //   Default => 0x00
    Write_Command(0x10+d/16);       // Set Higher Column Start Address for Page Addressing Mode
                                    //   Default => 0x10
}


void Set_Page_Addressing_Mode(void)
{
    Write_Command(0x20);            // Set Memory Page Addressing Mode
}

void Set_Vertical_Addressing_Mode(void)
{
    Write_Command(0x21);            // Set Memory Vertical Addressing Mode
}

void Set_Contrast_Control(unsigned char d)
{
    Write_Command(0x81);            // Set Contrast Control
    Write_Command(d);           //   Default => 0x7F
}

void Set_Segment_Remap(unsigned char d)
{
    Write_Command(d);           // Set Segment Re-Map
                        //   Default => 0xA0
                        //     0xA0 => Column Address 0 Mapped to SEG0
                        //     0xA1 => Column Address 0 Mapped to SEG127
}

void Set_Entire_Display(unsigned char d)
{
    Write_Command(d);           // Set Entire Display On / Off
                        //   Default => 0xA4
                        //     0xA4 => Normal Display
                        //     0xA5 => Entire Display On
}

void Set_Inverse_Display(unsigned char d)
{
    Write_Command(d);           // Set Inverse Display On/Off
                        //   Default => 0xA6
                        //     0xA6 => Normal Display
                        //     0xA7 => Inverse Display On
}

void Set_DCDC_Control_Mode(unsigned char d)
{
    Write_Command(0xad);            //Set DC-DC Control Mode
    Write_Command(d);               //DC-DC Setting Mode Set
}

void Set_Display_On_Off(unsigned char d)    
{
    Write_Command(d);           // Set Display On/Off
                        //   Default => 0xAE
                        //     0xAE => Display Off
                        //     0xAF => Display On
}

void Set_Page_Address(unsigned char d)
{
    Write_Command(0xb0);            // Set Page Address
    Write_Command(d);               // Page Address
}

void Set_Common_Remap(unsigned char d)
{
    Write_Command(d);   // Set COM Output Scan Direction
                        //   Default => 0xC0
                        //     0xC0 => Scan from COM0 to COM[N-1]
                        //     0xC8 => Scan from COM[N-1] to COM0
}

void Set_Display_Resolution(unsigned char d)
{
    Write_Command(0xa9);            //Set Display Resolution Command
    Write_Command(d);               //00= 64 COM⊙ 160 SEG
                                    //01= 96 COM⊙ 160 SEG
                                    //02=128 COM⊙ 160 SEG
                                    //03=160 COM⊙ 160 SEG
}

void Set_Display_Clock(unsigned char d)
{
    Write_Command(0xD5);            // Set Display Clock Divide Ratio / Oscillator Frequency
    Write_Command(d);               // Default => 0x50
                                    // D[3:0] => Display Clock Divider
                                    // D[7:4] => Oscillator Frequency
}

void Set_Precharge_Period(unsigned char d)
{
    Write_Command(0xD9);            // Set Pre-Charge Period
    Write_Command(d);               // Default => 0x22 (2 Display Clocks [Phase 2] / 2 Display Clocks [Phase 1])
                                    // D[3:0] => Phase 1 Period in 1~15 Display Clocks
                                    // D[7:4] => Phase 2 Period in 1~15 Display Clocks
}

void Set_VCOMH(unsigned char d)
{
    Write_Command(0xDB);            // Set VCOMH Deselect Level
    Write_Command(d);           //   Default => 0x35 (VCOMH = 1 x VREF )
}

void Set_VSEGH(unsigned char d)
{
    Write_Command(0xDC);            // Set VSEGH Deselect Level
    Write_Command(d);           //   Default => 0x35 (VSEGH = 1 x VREF )
}

void Set_VSL(unsigned char d)
{
    Write_Command(d);           // Set VSL
                                // Default => 0x30 
}

void Read_Modify_Write_Start(void)
{
    Write_Command(0xe0);            //Read-Modify-Write Start
}

void Read_Modify_Write_End(void)
{
    Write_Command(0xee);            //Read-Modify-Write End
}

void Set_NOP()
{
    Write_Command(0xE3);            // Command for No Operation
}



//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//  Show Character (5x7)
//
//    a: Database
//    b: Ascii
//    c: Start Page
//    d: Start Column
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
void Show_Font_big(unsigned char a, unsigned char b, unsigned char c, unsigned char d)
{
unsigned char i;

    Set_Page_Address(c);
    Set_Start_Column(d);

    for(i=0;i<11;i++)
    {
        Write_Data(Shefi[b-1][i]);
    }
    Write_Data(0x00);
}

void Show_Font_num(unsigned char a, unsigned char b, unsigned char c, unsigned char d)
{
unsigned int i;

    Set_Page_Address(c);
    Set_Start_Column(d);

    for(i=0;i<22;i++)
    {
        Write_Data(Shefinum[b-1][i]);
    }
    Write_Data(0x00);
}


void Show_Font57(unsigned char a, unsigned char b, unsigned char c, unsigned char d)
{
unsigned char i;

    Set_Page_Address(c);
    Set_Start_Column(d);

    for(i=0;i<5;i++)
    {
        Write_Data(Ascii_1[b-1][i]);
    }
    Write_Data(0x00);
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//  Show String
//
//    a: Database
//    b: Start Page
//    c: Start Column
//    * Must write "0" in the end...
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
void Show_String_big(unsigned char a, unsigned char *Data_Pointer, unsigned char b, unsigned char c)
{
unsigned char *Src_Pointer;

    Src_Pointer=Data_Pointer;
    Show_Font57(1,96,b,c);          // No-Break Space
                        //   Must be written first before the string start...

    while(1)
    {
        Show_Font_big(a,*Src_Pointer,b,c);
        Src_Pointer++;
        c+=13;
        if(*Src_Pointer == 0) break;
    }
}

void Show_String_num(unsigned char a, unsigned char *Data_Pointer, unsigned char b, unsigned char c)
{
unsigned char *Src_Pointer;

    Src_Pointer=Data_Pointer;
    Show_Font57(1,96,b,c);          // No-Break Space
                        //   Must be written first before the string start...

    while(1)
    {
        Show_Font_num(a,*Src_Pointer,b,c);
        Src_Pointer++;
        c+=26;
        if(*Src_Pointer == 0) break;
    }
}

void Show_String(unsigned char a, unsigned char *Data_Pointer, unsigned char b, unsigned char c)
{
unsigned char *Src_Pointer;

    Src_Pointer=Data_Pointer;
    Show_Font57(1,96,b,c);          // No-Break Space
                        //   Must be written first before the string start...

    while(1)
    {
        Show_Font57(a,*Src_Pointer,b,c);
        Src_Pointer++;
        c+=6;
        if(*Src_Pointer == 0) break;
    }
}



void OLED_initial(void)                     //SH1108
{
    unsigned char i,j;
    
    RES = 1;
    
    Set_Display_On_Off(0xAE);               //Display off

    Set_Contrast_Control(Brightness);       //set contrast

    Set_Page_Addressing_Mode();             //Set Memory Page addressing mode

    Set_Segment_Remap(0xA0);                //set segment re-map     0xA0 => Column Address 0 Mapped to SEG0

    Set_Entire_Display(0xA4);               //set entire display off

    Set_Inverse_Display(0xA6);              //set normal display 

    Set_DCDC_Control_Mode(0x80);            //set DC-DC off
       
    Set_Common_Remap(0xC0);                 //set commom output scan direction  0xC0 => Scan from COM0 to COM[N-1]
 
    Set_Display_Clock(0x60);                //set display clock divide ratio/osc frequency

    Set_Precharge_Period(0x47);             //set dis-charge/pre-charge period

    Set_VCOMH(0x35);                        //set VCOM deselect level

    Set_VSEGH(0x35);                        //set VSEGM deselect level

    Set_VSL(0x30);                          // SET VSL

    Set_Display_Resolution(0x03);           // Set display resolution   03=160 COM⊙ 160 SEG

    for(i=0;i<=16;i++)
    {
        Set_Start_Column(0x00);  //set column address
        Set_Page_Address(i);     //Set Page Address
        
        for(j=0;j<Max_Column;j++)
        {
            Write_Data(0x00);
        }
    }
    
    
    Set_Display_On_Off(0xAF);      //display on
}

void Frame_pattern()//Frame Pattern
{       
  unsigned char i,j;

    for(i=0;i<=16;i++)
    {
        Set_Start_Column(0x00);  //set column address
        Set_Page_Address(i);     //Set Page Address
            
        for(j=0;j<Max_Column;j++)
        {
            Write_Data(FramePic[i*Max_Column+j]);
        }
    }
}


void clear_screen()
{
    unsigned char clearodd[2] = {41,0};
    unsigned char cleareven[2] = {42,0};
    unsigned char clearodd1[2] = {43,0};
    unsigned char cleareven1[2] = {44,0};
    unsigned char clearodd2[2] = {41,0};
    unsigned char cleareven2[2] = {42,0};
    unsigned char clearodd3[2] = {43,0};
    unsigned char cleareven3[2] = {44,0};
    unsigned char clearodd4[2] = {41,0};
    unsigned char cleareven4[2] = {42,0};
    unsigned char clearodd5[2] = {43,0};
    unsigned char cleareven5[2] = {44,0};
    Show_String_num(2,clearodd,8,45);
    Show_String_num(2,cleareven,9,45);
    Show_String_num(2,clearodd1,10,45);
    Show_String_num(2,cleareven1,11,45);
    Show_String_num(2,clearodd2,8,71);
    Show_String_num(2,cleareven2,9,71);
    Show_String_num(2,clearodd3,10,71);
    Show_String_num(2,cleareven3,11,71);
    Show_String_num(2,clearodd4,8,97);
    Show_String_num(2,cleareven4,9,97);
    Show_String_num(2,clearodd5,10,97);
    Show_String_num(2,cleareven5,11,97);
    Show_String_num(2,clearodd4,8,58);
    Show_String_num(2,cleareven4,9,58);
    Show_String_num(2,clearodd5,10,58);
    Show_String_num(2,cleareven5,11,58);
    Show_String_num(2,clearodd4,8,84);
    Show_String_num(2,cleareven4,9,84);
    Show_String_num(2,clearodd5,10,84);
    Show_String_num(2,cleareven5,11,84);
}

void oledwrite(int num1,int num2,int num3,int analog_read)
{
    unsigned char sh[8] = {1,3,5,7,9,11,13,0};
    unsigned char sh1[8] = {2,4,6,8,10,12,14,0};
    unsigned char Name[4]={54,33,44,0};
//    unsigned char Name[10]={52,69,77,80,82,65,84,85,82,0};
    unsigned char dot[2]={14,0};
    unsigned char a,b,c;
    Show_String_big(2,sh,4,35);
    Show_String_big(2,sh1,5,35);
    Show_String(1,Name,14,75);
//    Show_String(1,dot,11,95);
    clear_screen();
    switch(num1)
            {
                case 0:
                    a = 1;
                    break;
                case 1:
                    a = 5;
                    break;
                case 2:
                    a = 9;
                    break;
                case 3:
                    a = 13;
                    break;
                case 4:
                    a = 17;
                    break;
                case 5:
                    a = 21;
                    break;
                case 6:
                    a = 25;
                    break;
                case 7:
                    a = 29;
                    break;
                case 8:
                    a = 33;
                    break;
                case 9:
                    a = 37;
                    break;
            }
            switch(num2)
            {
                case 0:
                    b = 1;
                    break;
                case 1:
                    b = 5;
                    break;
                case 2:
                    b = 9;
                    break;
                case 3:
                    b = 13;
                    break;
                case 4:
                    b = 17;
                    break;
                case 5:
                    b = 21;
                    break;
                case 6:
                    b = 25;
                    break;
                case 7:
                    b = 29;
                    break;
                case 8:
                    b = 33;
                    break;
                case 9:
                    b = 37;
                    break;
            }
            switch(num3)
            {
                case 0:
                    c = 1;
                    break;
                case 1:
                    c = 5;
                    break;
                case 2:
                    c = 9;
                    break;
                case 3:
                    c = 13;
                    break;
                case 4:
                    c = 17;
                    break;
                case 5:
                    c = 21;
                    break;
                case 6:
                    c = 25;
                    break;
                case 7:
                    c = 29;
                    break;
                case 8:
                    c = 33;
                    break;
                case 9:
                    c = 37;
                    break;
            }
        unsigned char numodd[2] = {a,0};
        unsigned char numeven[2] = {(a+1),0};
        unsigned char numodd1[2] = {(a+2),0};
        unsigned char numeven1[2] = {(a+3),0};
        unsigned char numodd2[2] = {b,0};
        unsigned char numeven2[2] = {(b+1),0};
        unsigned char numodd3[2] = {(b+2),0};
        unsigned char numeven3[2] = {(b+3),0};
        unsigned char numodd4[2] = {c,0};
        unsigned char numeven4[2] = {(c+1),0};
        unsigned char numodd5[2] = {(c+2),0};
        unsigned char numeven5[2] = {(c+3),0};
        if(analog_read >=100)
        {
            Show_String_num(2,numodd,8,45);
            Show_String_num(2,numeven,9,45);
            Show_String_num(2,numodd1,10,45);
            Show_String_num(2,numeven1,11,45);
            Show_String_num(2,numodd2,8,71);
            Show_String_num(2,numeven2,9,71);
            Show_String_num(2,numodd3,10,71);
            Show_String_num(2,numeven3,11,71);
            Show_String_num(2,numodd4,8,97);
            Show_String_num(2,numeven4,9,97);
            Show_String_num(2,numodd5,10,97);
            Show_String_num(2,numeven5,11,97);
        }
        else if(analog_read < 10)
        {
            Show_String_num(2,numodd4,8,71);
            Show_String_num(2,numeven4,9,71);
            Show_String_num(2,numodd5,10,71);
            Show_String_num(2,numeven5,11,71);
        }
        else
        {
            Show_String_num(2,numodd2,8,58);
            Show_String_num(2,numeven2,9,58);
            Show_String_num(2,numodd3,10,58);
            Show_String_num(2,numeven3,11,58);
            Show_String_num(2,numodd4,8,84);
            Show_String_num(2,numeven4,9,84);
            Show_String_num(2,numodd5,10,84);
            Show_String_num(2,numeven5,11,84);
        }
        
        
}
