#include "mbed.h"
#include "ble/BLE.h"
#include "ble/services/HeartRateService.h"
#include <stdbool.h>
#include <stdint.h>

class ModifiedHeartRateService : HeartRateService{
public:

    ModifiedHeartRateService(BLE &_ble, uint8_t hrmCounter, uint8_t location) : HeartRateService(_ble,hrmCounter,location){};
    ~ModifiedHeartRateService(){};
    
    void onDataWritten(const GattWriteCallbackParams *params) {
        if (params->handle == controlPoint.getValueAttribute().getHandle()) {
            ble.readCharacteristicValue(controlPoint.getValueAttribute().getHandle(), trig1, &bytesRead);//read command
            /* Do something here if the new value is 1; else you can override this method by
             * extending this class.
             * @NOTE: If you are extending this class, be sure to also call
             * ble.onDataWritten(this, &ExtendedHRService::onDataWritten); in
             * your constructor.
             */
        }
    }
    
    void updateHeartRate(uint8_t byte){
        updateHeartRate(byte);   
    }

    uint8_t              trig1[2];
    uint16_t             bytesRead;
};