#include "mbed.h"
#include <stdbool.h>
#include <stdint.h>
#include "nrf.h"
#include "nrf_gpio.h"


DigitalOut measure_led(P0_15);
DigitalOut alive_led(P0_17);
DigitalIn main_power(P0_5);
DigitalOut V33ON(P0_20);
DigitalOut LCDON(P0_19);
DigitalOut scl(P0_22);
DigitalOut sda(P0_23);
AnalogIn a0(P0_4);//analog input
DigitalOut clk(P0_7);//sensor clk
AnalogIn ref(P0_6);//serial input flag
DigitalOut wake_up(P0_24);//wake up button
DigitalIn swl(P0_16,PullUp);//secondry click


int reflect_data[] = {0,};
int i = 0;
float analog_read = 0;

void wdt_init(void)
{
    NRF_WDT->CONFIG = (WDT_CONFIG_HALT_Pause << WDT_CONFIG_HALT_Pos) | ( WDT_CONFIG_SLEEP_Run << WDT_CONFIG_SLEEP_Pos);
    NRF_WDT->CRV = 15*32768;   //ca 3 sek. timout
    NRF_WDT->RREN |= WDT_RREN_RR0_Msk;  //Enable reload register 0
    NRF_WDT->TASKS_START = 1;
}