#include "mbed.h"
#include "ble/BLE.h"
#include "ModifiedHeartRateService.h"
//#include "ble/services/BatteryService.h"
#include "ble/services/DeviceInformationService.h"
#include <stdbool.h>
#include <stdint.h>
#include "oled.h"
#include "nrf.h"
#include "nrf51.h"
#include "nrf_gpio.h"
#include "Refrect.h"


//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//  Pin Definition
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

//Serial pc(P0_11,P0_9);

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

const static char     DEVICE_NAME[]        = "Valiber-V1";
static const uint16_t uuid16_list[]        = {GattService::UUID_HEART_RATE_SERVICE,
                                              GattService::UUID_DEVICE_INFORMATION_SERVICE};
static volatile bool  triggerSensorPolling = false;
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//  Variable Definition
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

uint8_t hrmCounter = 0; // init ble Counter
uint8_t oledCounter = 0; // init oled Counter
float avg1 = 0;
uint64_t avg2 = 0;
float calibration = 0;
uint16_t result = 0;
int avgcnt1 = 0;
int avgcnt2 = 0;
int swbg = 0;
int swen = 0;
int shut_down = 0;
ModifiedHeartRateService         *hrService;
DeviceInformationService *deviceInfo;
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params);

uint8_t              trig1[2];
uint16_t             bytesRead;

void blink()
{
    Set_Display_On_Off(0xAE);
    wait_ms(50);
    Set_Display_On_Off(0xAF);
}

void bleInitComplete(BLE::InitializationCompleteCallbackContext *params)
{
    BLE &ble          = params->ble;
    ble_error_t error = params->error;

    if (error != BLE_ERROR_NONE) {
        return;
    }

    ble.gap().onDisconnection(disconnectionCallback);
    /* Setup primary service. */
    hrService = new ModifiedHeartRateService(ble, hrmCounter, HeartRateService::LOCATION_FINGER);
    /* Setup auxiliary service. */
    deviceInfo = new DeviceInformationService(ble, "ARM", "Model1", "SN1", "hw-rev1", "fw-rev1", "soft-rev1");
    /* Setup advertising. */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::GENERIC_HEART_RATE_SENSOR);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.gap().setAdvertisingInterval(1000); /* 1000ms */
    ble.gap().startAdvertising();
}

void cal()
{
    measure_led = 0;
    calibration = 0;
    wait(0.5);
    analog_read = (1-a0.read())*1000;
//    analog_read = ref.read()*1000;
    calibration = analog_read;
    part_num(analog_read);
//    pc.printf("Subtruction : %f\n",analog_read);
//    wait(0.1);
    hrmCounter = 55;
    hrService->updateHeartRate(hrmCounter);//hrs write command
    wait_ms(70);
    hrmCounter = num1;
    hrService->updateHeartRate(hrmCounter);//hrs write command
    wait_ms(70);
    hrmCounter = num2;
    hrService->updateHeartRate(hrmCounter);//hrs write command
    wait_ms(70);
    hrmCounter = num3;
    hrService->updateHeartRate(hrmCounter);//hrs write command
    wait_ms(70);
    unsigned char Name1[12]={35,65,76,73,66,82,65,84,69,68,96,0};
    Show_String(1,Name1,14,55);
    measure_led = 1;
}

void meas()
{
    avg1 = 0;
    measure_led = 0;
    wait(0.5);
    analog_read = (1-a0.read())*1000;
//    analog_read = ref.read()*1000;
    analog_read = analog_read - calibration;
    analog_read = analog_read*1.1154416 -0.004;
    if(analog_read < 0)
    {
        analog_read = analog_read* -1;
    }
    part_num(analog_read);
//    pc.printf("%f\n",analog_read);
//    wait(0.1);
    hrmCounter = 55;
    hrService->updateHeartRate(hrmCounter);//hrs write command
    wait_ms(70);
    hrmCounter = num1;
    hrService->updateHeartRate(hrmCounter);//hrs write command
    wait_ms(70);
    hrmCounter = num2;
    hrService->updateHeartRate(hrmCounter);//hrs write command
    wait_ms(70);
    hrmCounter = num3;
    hrService->updateHeartRate(hrmCounter);//hrs write command
    wait_ms(70);
    unsigned char Name1[12]={96,96,96,54,33,44,96,96,96,96,96,0};
    Show_String(1,Name1,14,55);
    measure_led = 1;
}

void start_up()
{
    Set_Display_On_Off(0xAF);
    NRF_RADIO->POWER = 1;
}

void btnrise()
{
    alive_led = 1;
    if((swbg<500)&&(swbg>10))
    {
        meas();
    }
    if((swbg > 500)&&(swbg <1000))
    {
        alive_led = 0;
        cal();
    }
    if(swbg > 1000)
    {
        shut_down = 1;
    }
    swbg = 0;
}

void btnfall()
{
    NRF_POWER->SYSTEMOFF = 0;
    start_up();
    alive_led = 0;
    while(main_power == 1)
    {
        swbg++;
        wait_ms(2);
        if((swbg > 500)&&(swbg <1000))
        {
            unsigned char Name1[12]={35,65,76,73,66,82,65,84,69,31,96,0};
            Show_String(1,Name1,14,55);
            blink();
            blink();
            blink();
            blink();      
        }
        if(swbg > 1000)
        {
            unsigned char Name1[12]={51,72,85,84,96,36,79,87,78,31,96,0};
            Show_String(1,Name1,14,55);
            alive_led = 1;
        }
    }
}



int main(void)
{
    wake_up = 1;
    alive_led = 1;
//    while(1){
//        if(main_power.read()){
//            alive_led = 0;
//        }
//        else{
//            alive_led = 1;
//        }
//    }
    V33ON = 1;
    LCDON = 1;
    measure_led = 1;
    wdt_init();
//    main_power.mode(PullUp);
//    main_power.rise(&btnrise);
//    main_power.fall(&btnfall);
    OLED_initial();
    oledwrite(0,0,0,0);//oled structure initialization
    BLE& ble = BLE::Instance(BLE::DEFAULT_INSTANCE);
    ble.init(bleInitComplete);
    while (ble.hasInitialized()  == false) { /* spin loop */ }
    hrmCounter = 0;
    hrService->updateHeartRate(hrmCounter);//hrs write command
    part_num(hrmCounter);
    while (1) {//Main loop  
        if (ble.getGapState().connected)//Checks ble connection
        { 
            NRF_WDT->RR[0] = WDT_RR_RR_Reload;
            if(hrService->trig1[0] == 5) //"button" conditioning - trig1 is the hrs read buffer (furture info in heartrateservice.h, control point onDataWritten)
            {
                cal();
                hrService->trig1[0] = 0;//reset the value to zero, simulating a click button
            }
            if(hrService->trig1[0] == 4) //"button" conditioning - trig1 is the hrs read buffer (furture info in heartrateservice.h, control point onDataWritten)
            {
                meas();
                hrService->trig1[0] = 0;//reset the value to zero, simulating a click button
            }
            if(hrService->trig1[0] == 3) //repeatedly measure "button" conditioning - trig1 is the hrs read buffer (furture info in heartrateservice.h, control point onDataWritten)
            {
                meas();
//                hrService->trig1[0] = 0;//reset the value to zero, simulating a click button
            }
            if(shut_down == 1)
            {
                LCDON = 0;
                V33ON = 0;
                NRF_RADIO->POWER = 0;
                NRF_POWER->SYSTEMOFF =POWER_SYSTEMOFF_SYSTEMOFF_Enter;
            }
        } 
        else 
        {
            //NRF_WDT->RR[0] = WDT_RR_RR_Reload;
//            if(shut_down == 1)
//            {
//                LCDON = 0;
//                V33ON = 0;
//                measure_led = 0;
//                alive_led = 1;
//                clk = 0;
//                SCLK = 0;
//                SDIN = 0;
//                RES = 0;
//                CS = 0;
//                DC = 0;
//                scl = 1;
//                sda = 1;
//                wait_ms(100);
//                NRF_RADIO->POWER = 0;
//                NRF_POWER->SYSTEMOFF =POWER_SYSTEMOFF_SYSTEMOFF_Enter;
//            }
        }
    }
}

void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
//    BLE::Instance(BLE::DEFAULT_INSTANCE).gap().startAdvertising(); // restart advertisin
//    blink();
//    blink();
//    blink();
//    blink();
//    blink();
//    blink();
}