/**
@file main.cpp
@brief code implementation
*/

#include "main.h"
#include "mbed.h"
#include "BMP180.h"
#include "N5110.h"
#include "PowerControl/PowerControl.h"
#include "PowerControl/EthernetPowerControl.h"

/** timer associated with temperature */
void timerTExpired(){
    timerTFlag = 1;
}
/** timer associated with pressure */
void timerPExpired(){
    timerPFlag = 1;
}
/** timer associated with error */
void timerEExpired(){
    timerEFlag = 1;
}
/** timer associated with light */
void timerLExpired(){
    timerLFlag = 1;
}
/** function to set flag to 1 when button pressed */
void buttonPressed(){
    buttonFlag=1;
}
/** function called when error occurs */
void error(){
    timerE.attach(&timerEExpired,2.0);
    while(1){
        if (timerEFlag){
            timerEFlag=0;
            buzzer.period(0.01);
            buzzer=0.5;
            led=1;
            wait(1.0);
            led=0;
        }
    }
}
/** function to write data to file */
void writeDataToFile(int data) {
    leds=3; //turn on LEDs for feedback
    FILE *fp=fopen("/local/log.txt","a"); //open log.txt for appending
    //if the file doesn't exist it is created, if it exists, data is appended to the end
    fprintf(fp,"Counter=%i\n",data); //print string to file
    fclose(fp); //close file
    leds=0; //turn off LEDs to signify file access has finished
}
/** function to call the temperature */
void callTemp(){
    measurement();
    clearCells();
    lcd.printString("Menu",0,5);
    char bufferT[14];
    int length=sprintf(bufferT,"T = %.2f C",temperature);
    if (length<=14){
        lcd.printString(bufferT,10,2);
    }
    if (temperature>30){
        error();
    }
}
/** function to call pressure */
void callPress(){
    measurement();
    clearCells();
    lcd.printString("Menu",0,5);
    char bufferP[14];
    int length=sprintf(bufferP,"P = %.2f mb",pressure);
    if (length<=14){
        lcd.printString(bufferP,0,2);
    }
    if (pressure<337){
        error();
    }
}
/** function to call light */
void callLight(){
    float light = ((1-LDR)*100);
    clearCells();
    lcd.printString("Menu",0,5);
    char bufferL[14];
    int length=sprintf(bufferL,"L = %.2f %%",light);
    if (length<=14){
        lcd.printString(bufferL,10,2);
    }
    if (light>90){
        error();
    }
}
/** function to reads temperature */
void readTemp(){
    callT.attach(&callTemp,0.1);
    timerT.attach(&timerTExpired,60);
    while(1){
        if (timerTFlag){
            timerTFlag=0;
            measurement();
            clearCells();
            lcd.printString("Menu",0,5);
            char bufferT[14];
            int length=sprintf(bufferT,"T = %.2f C",temperature);
            writeDataToFile(counter); //write current value to disk
            counter++; //increment counter
            if (length<=14){
                lcd.printString(bufferT,10,2);
            }
            if (temperature>30){
                error();
            }
        }
        if (buttonFlag){
            buttonFlag=0;
            menu();
        }
    }
}
/** function to read pressure */
void readPress(){
    callP.attach(&callPress,0.1);
    timerP.attach(&timerPExpired,1800);
    while(1){
        if (timerPFlag){
            timerPFlag=0;
            measurement();
            clearCells();
            lcd.printString("Menu",0,5);
            char bufferP[14];
            int length=sprintf(bufferP,"P = %.2f mb",pressure);
            writeDataToFile(counter); //write current value to disk
            counter++; //increment counter
            if (length<=14){
                lcd.printString(bufferP,0,2);
            }
            if (pressure<337){
                error();
            }
        }
        if (buttonFlag){
            buttonFlag=0;
            menu();
        }
    }
}
/** function to read light */
void readLight(){
    callL.attach(&callLight,0.1);
    timerL.attach(&timerLExpired,60);
    while(1){
        if (timerLFlag){
            timerLFlag=0;
            clearCells();
            float light = ((1-LDR)*100);
            lcd.printString("Menu",0,5);
            char bufferL[14];
            int length=sprintf(bufferL,"L = %.2f %%",light);
            writeDataToFile(counter); //write current value to disk
            counter++; //increment counter
            if (length<=14){
                lcd.printString(bufferL,10,2);
            }
            if (light>90){
                error();
            }
        }
        if (buttonFlag){
            buttonFlag=0;
            menu();
        }
    }
}    
/** function to take BMP180 meaasurement */
void measurement(){
    Measurement measurement;
    measurement=bmp180.readValues();
    temperature=measurement.temperature;
    pressure=measurement.pressure;
}
/** function to plot temperature graph */
void tempGraph(){
    timerT.attach(&timerTExpired,2);
    int j=0; //start graph on left hand side of screen
    while(1){
        lcd.printString("Menu",0,5);
        if (timerTFlag){
            timerTFlag=0;
            clearCells();
            float tempArray[84]; //create array of temperature values
            measurement(); //read in the measured values of temperature
            tempArray[j]=(temperature/47);
            j++; //add one to j so that the next point plotted moves across the screen by one pixel
            lcd.plotArray(tempArray); //plot the array
            writeDataToFile(counter); //write current value to disk
            counter++; //increment counter
            wait(0.1); //wait one second before plotting the next point
            if (j>83){
                j=0;
            }
            if (temperature>30){
                error();
            }
        }
        if (buttonFlag){
            buttonFlag=0;
            menu();
        }
    }
}
/** function to plot pressure graph */
void pressGraph(){
    timerP.attach(&timerPExpired,2);
    int j=0;
    while(1){
        lcd.printString("Menu",0,5);
        if (timerPFlag){
            timerPFlag=0;
            clearCells();
            float pressArray[84];
            measurement();
            pressArray[j]=(pressure/1100);
            j++;
            lcd.plotArray(pressArray);
            writeDataToFile(counter); //write current value to disk
            counter++; //increment counter
            wait(0.1);
            if (j>83){
                j=0;
            }
            if (pressure<337){
                error();
            }
        }
        if (buttonFlag){
            buttonFlag=0;
            menu();
        }     
    }
}
/** function to plot light graph */
void lightGraph(){
    timerL.attach(&timerLExpired,2);
    int j=0;
    while(1){
        lcd.printString("Menu",0,5);
        if (timerLFlag){
            timerLFlag=0;
            clearCells();
            float lightArray[84];
            float light = ((1-LDR)*100);
            lightArray[j]=((light/100)+0.2);
            j++;
            lcd.plotArray(lightArray);
            writeDataToFile(counter); //write current value to disk
            counter++; //increment counter
            wait(0.1);
            if (j>83){
                j=0;
            }
            if (light>90){
                error();
            }
        }
        if (buttonFlag){
            buttonFlag=0;
            menu();
        }
    }
}
/** function to display menu options */
void menu(){
    buttonleft.rise(&buttonPressed);
    while(1) {
        wait (0.1);
        lcd.normalMode(); //normal LCD colour mode
        lcd.setBrightness(0.5); //LCD backlight set to 50% brightness
        if (POT>(2.0/3.0)) {
            clearCells();
            lcd.printString("Temperature",10,1);
            lcd.printString(">",80,2);
            lcd.printString("Graph",0,5);
            lcd.printString("Current",43,5);
            if (buttonFlag){ //left button takes the user to the graph option
                buttonFlag=0;
                clearCells();
                tempGraph();
            }
            if (BUT2>0.9) { //right button takes the user to the current reading
                clearCells();
                readTemp();
            }
        }
        if ((POT>1.0/3.0)&&(POT<2.0/3.0)) {
            clearCells();
            lcd.printString("Pressure",20,1);
            lcd.printString("<",0,2);
            lcd.printString(">",80,2);
            lcd.printString("Graph",0,5);
            lcd.printString("Current",43,5);
            if (buttonFlag) {
                buttonFlag=0;
                clearCells();
                pressGraph();
            }
            if (BUT2>0.9) {
                clearCells();
                readPress();
            }
        }
        if (POT<(1.0/3.0)) {
            clearCells();
            lcd.printString("Light",30,1);
            lcd.printString("<",0,2);
            lcd.printString("Graph",0,5);
            lcd.printString("Current",43,5);
            if (buttonFlag) {
                buttonFlag=0;
                clearCells();
                lightGraph();
            }
            if (BUT2>0.9) {
                clearCells(); 
                readLight();
            }
        }
    }
}
/** function to clear cells */
void clearCells ()
{
    //loop through cells and clear
    for (int i=0; i<nx; i++) {
        for (int j=0; j<ny; j++) {
            lcd.clearPixel(i,j);
        }
    }
    lcd.refresh (); //must refresh to write buffer to display
}
 /** main function */
int main(){
    while(1){
        PHY_PowerDown(); //powers down the ethernet link
        lcd.init();
        bmp180.init();
        menu();
    }
}