#include "mbed.h"
#include "ble/BLE.h"
#include "BME280.h"

BLE  ble;

// Serial pc(USBTX, USBRX);

BME280 bme(P0_3, P0_4);

const static uint16_t environment_ser_uuid = 0xA000;

const static uint16_t temperature_chr_uuid = 0xA001;
uint8_t             tempPayload[3] = { 0, 0, 0 };
GattCharacteristic temp_chr   ( temperature_chr_uuid, tempPayload, sizeof(tempPayload), sizeof(tempPayload),
                                   GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY |
                                   GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ);

const static uint16_t humidity_chr_uuid = 0xA002;
uint8_t             humidityPayload[3] = { 0, 0, 0 };
GattCharacteristic humidity_chr   ( humidity_chr_uuid, humidityPayload, sizeof(humidityPayload), sizeof(humidityPayload),
                                   GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY |
                                   GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ);
                                   
const static uint16_t pressure_chr_uuid = 0xA003;
uint8_t             pressurePayload[3] = { 0, 0, 0 };
GattCharacteristic pressure_chr   ( pressure_chr_uuid, pressurePayload, sizeof(pressurePayload), sizeof(pressurePayload),
                                   GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY |
                                   GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ);


GattCharacteristic *envChars[] = { &temp_chr, &humidity_chr, &pressure_chr };
GattService        envService(environment_ser_uuid, envChars, sizeof(envChars) / sizeof(GattCharacteristic *));



const static uint16_t count_ser_uuid = 0xB000;
const static uint16_t count_chr_uuid = 0xB001;
uint8_t             counter[1] = { 0 };
GattCharacteristic count_chr   ( count_chr_uuid, counter, sizeof(counter), sizeof(counter),
                                 GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY |
                                 GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ);
GattCharacteristic *count_chrs[] = {&count_chr, };
GattService        countService(count_ser_uuid, count_chrs, sizeof(count_chrs) / sizeof(GattCharacteristic *));



static const uint16_t uuid16_list[] = {environment_ser_uuid, count_ser_uuid};






static volatile bool triggerSensorPolling = false;

void periodicCallback(void);
void update_values(void);


void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    // pc.printf("Disconnected \r\n");
    // pc.printf("Restart advertising \r\n");
    ble.startAdvertising();
}
void tare(void);
int main(void)
{
    Ticker ticker;
    ticker.attach(periodicCallback, 2.0 );

    ble.init();
    ble.onDisconnection(disconnectionCallback);
    // pc.printf("hello\r\n");
    // pc.printf("hi\r\n");
    // pc.baud(9600);
    // pc.printf("SimpleChat Init \r\n");

    // setup advertising
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME,
                                     (const uint8_t *)"Biscuit", sizeof("Biscuit") - 1);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));

    // 100ms; in multiples of 0.625ms.
    ble.setAdvertisingInterval(160);

    ble.addService(countService);
    ble.addService(envService);

    ble.startAdvertising();
    // pc.printf("Advertising Start \r\n");

    while(1) {
        if (triggerSensorPolling) {
            triggerSensorPolling = false;
            update_values();
        } else {
            ble.waitForEvent();
        }
    }
}

void periodicCallback(void)
{
    triggerSensorPolling = true;
}


void update_values(void) {    
    float temp = bme.getTemperature();
    float humidity = bme.getHumidity();
    float pressure = bme.getPressure();
    
    if (ble.getGapState().connected ) {
        uint32_t temp_ = temp * 10000;
        tempPayload[0] = (uint8_t)((temp_ & 0xFF0000) >> 16);
        tempPayload[1] = (uint8_t)((temp_ & 0x00FF00) >> 8);
        tempPayload[2] = (uint8_t)(temp_ & 0x0000FF);
        ble.updateCharacteristicValue(temp_chr.getValueAttribute().getHandle(), tempPayload, sizeof(tempPayload));
        
        uint32_t humidity_ = humidity * 10000;
        humidityPayload[0] = (uint8_t)((humidity_ & 0xFF0000) >> 16);
        humidityPayload[1] = (uint8_t)((humidity_ & 0x00FF00) >> 8);
        humidityPayload[2] = (uint8_t)(humidity_ & 0x0000FF);
        ble.updateCharacteristicValue(humidity_chr.getValueAttribute().getHandle(), humidityPayload, sizeof(humidityPayload));
        
        uint32_t pressure_ = pressure * 10000;
        pressurePayload[0] = (uint8_t)((pressure_ & 0xFF0000) >> 16);
        pressurePayload[1] = (uint8_t)((pressure_ & 0x00FF00) >> 8);
        pressurePayload[2] = (uint8_t)(pressure_ & 0x0000FF);
        ble.updateCharacteristicValue(pressure_chr.getValueAttribute().getHandle(), pressurePayload, sizeof(pressurePayload));
    }
    
}

